/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "acl");

    public static boolean isAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.AUTHORIZATION);
    }

    public static boolean isCellAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_AUTHORIZATION);
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(Table ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
        return protocol;
    }

    private static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().grant(new UserPermission(userName, Permission.newBuilder(tableName).withFamily(family).withQualifier(qual).withActions(actions).build()), mergeExistingPermissions);
    }

    public static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, tableName, userName, family, qual, true, actions);
    }

    private static void grant(Connection connection, String namespace, String userName, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().grant(new UserPermission(userName, Permission.newBuilder(namespace).withActions(actions).build()), mergeExistingPermissions);
    }

    public static void grant(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, namespace, userName, true, actions);
    }

    private static void grant(Connection connection, String userName, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().grant(new UserPermission(userName, Permission.newBuilder().withActions(actions).build()), mergeExistingPermissions);
    }

    public static void grant(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, userName, true, actions);
    }

    public static boolean isAccessControllerRunning(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Admin admin = connection.getAdmin();){
            boolean bl = admin.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
    }

    public static void revoke(Connection connection, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().revoke(new UserPermission(username, Permission.newBuilder(tableName).withFamily(family).withQualifier(qualifier).withActions(actions).build()));
    }

    public static void revoke(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().revoke(new UserPermission(userName, Permission.newBuilder(namespace).withActions(actions).build()));
    }

    public static void revoke(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        connection.getAdmin().revoke(new UserPermission(userName, Permission.newBuilder().withActions(actions).build()));
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex) throws Throwable {
        return AccessControlClient.getUserPermissions(connection, tableRegex, "");
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex, String userName) throws Throwable {
        ArrayList<UserPermission> permList = new ArrayList();
        try (Admin admin = connection.getAdmin();){
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = admin.getUserPermissions(GetUserPermissionsRequest.newBuilder().withUserName(userName).build());
            } else if (tableRegex.charAt(0) == '@') {
                String namespaceRegex = tableRegex.substring(1);
                for (NamespaceDescriptor nsds : admin.listNamespaceDescriptors()) {
                    String namespace = nsds.getName();
                    if (!namespace.matches(namespaceRegex)) continue;
                    permList.addAll(admin.getUserPermissions(GetUserPermissionsRequest.newBuilder(namespace).withUserName(userName).build()));
                }
            } else {
                List<TableDescriptor> htds = admin.listTableDescriptors(Pattern.compile(tableRegex), true);
                for (TableDescriptor htd : htds) {
                    permList.addAll(admin.getUserPermissions(GetUserPermissionsRequest.newBuilder(htd.getTableName()).withUserName(userName).build()));
                }
            }
        }
        return permList;
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex, byte[] columnFamily) throws Throwable {
        return AccessControlClient.getUserPermissions(connection, tableRegex, columnFamily, null, "");
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex, byte[] columnFamily, String userName) throws Throwable {
        return AccessControlClient.getUserPermissions(connection, tableRegex, columnFamily, null, userName);
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex, byte[] columnFamily, byte[] columnQualifier) throws Throwable {
        return AccessControlClient.getUserPermissions(connection, tableRegex, columnFamily, columnQualifier, "");
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex, byte[] columnFamily, byte[] columnQualifier, String userName) throws Throwable {
        if (tableRegex == null || tableRegex.isEmpty() || tableRegex.charAt(0) == '@') {
            throw new IllegalArgumentException("Table name can't be null or empty or a namespace.");
        }
        ArrayList<UserPermission> permList = new ArrayList<UserPermission>();
        try (Admin admin = connection.getAdmin();){
            List<TableDescriptor> htds = admin.listTableDescriptors(Pattern.compile(tableRegex), true);
            for (TableDescriptor htd : htds) {
                permList.addAll(admin.getUserPermissions(GetUserPermissionsRequest.newBuilder(htd.getTableName()).withFamily(columnFamily).withQualifier(columnQualifier).withUserName(userName).build()));
            }
        }
        return permList;
    }

    public static boolean hasPermission(Connection connection, String tableName, String columnFamily, String columnQualifier, String userName, Permission.Action ... actions) throws Throwable {
        return AccessControlClient.hasPermission(connection, tableName, Bytes.toBytes(columnFamily), Bytes.toBytes(columnQualifier), userName, actions);
    }

    public static boolean hasPermission(Connection connection, String tableName, byte[] columnFamily, byte[] columnQualifier, String userName, Permission.Action ... actions) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)tableName) || StringUtils.isEmpty((CharSequence)userName)) {
            throw new IllegalArgumentException("Table and user name can't be null or empty.");
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>(1);
        permissions.add(Permission.newBuilder(TableName.valueOf(tableName)).withFamily(columnFamily).withQualifier(columnQualifier).withActions(actions).build());
        return connection.getAdmin().hasUserPermissions(userName, permissions).get(0);
    }
}

