/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SyncFuture {
    private static final long NOT_DONE = -1L;
    private Thread t;
    private final ReentrantLock doneLock = new ReentrantLock();
    private final Condition doneCondition = this.doneLock.newCondition();
    private long doneTxid;
    private Throwable throwable;
    private long txid;
    private boolean forceSync;

    SyncFuture() {
    }

    SyncFuture reset(long txid, boolean forceSync) {
        if (this.t != null && this.t != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        this.t = Thread.currentThread();
        if (!this.isDone()) {
            throw new IllegalStateException("" + txid + " " + Thread.currentThread());
        }
        this.doneTxid = -1L;
        this.forceSync = forceSync;
        this.txid = txid;
        this.throwable = null;
        return this;
    }

    public String toString() {
        return "done=" + this.isDone() + ", txid=" + this.txid + " threadID=" + this.t.getId() + " threadName=" + this.t.getName();
    }

    long getTxid() {
        return this.txid;
    }

    boolean isForceSync() {
        return this.forceSync;
    }

    Thread getThread() {
        return this.t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean done(long txid, Throwable t) {
        this.doneLock.lock();
        try {
            if (this.doneTxid != -1L) {
                boolean bl = false;
                return bl;
            }
            this.throwable = t;
            if (txid < this.txid && this.throwable == null) {
                this.throwable = new IllegalStateException("done txid=" + txid + ", my txid=" + this.txid);
            }
            this.doneTxid = txid;
            this.doneCondition.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.doneLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long get(long timeoutNs) throws InterruptedException, ExecutionException, TimeoutIOException {
        this.doneLock.lock();
        try {
            while (this.doneTxid == -1L) {
                if (this.doneCondition.await(timeoutNs, TimeUnit.NANOSECONDS)) continue;
                throw new TimeoutIOException("Failed to get sync result after " + TimeUnit.NANOSECONDS.toMillis(timeoutNs) + " ms for txid=" + this.txid + ", WAL system stuck?");
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            long l = this.doneTxid;
            return l;
        }
        finally {
            this.doneLock.unlock();
        }
    }

    boolean isDone() {
        this.doneLock.lock();
        try {
            boolean bl = this.doneTxid != -1L;
            return bl;
        }
        finally {
            this.doneLock.unlock();
        }
    }

    Throwable getThrowable() {
        this.doneLock.lock();
        try {
            if (this.doneTxid == -1L) {
                Throwable throwable = null;
                return throwable;
            }
            Throwable throwable = this.throwable;
            return throwable;
        }
        finally {
            this.doneLock.unlock();
        }
    }
}

