/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.IncludeAllCompactionQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.MajorCompactionScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.MinorCompactionScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.StripeCompactionScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class CompactionScanQueryMatcher
extends ScanQueryMatcher {
    protected final long maxReadPointToTrackVersions;
    protected final DeleteTracker deletes;
    protected final KeepDeletedCells keepDeletedCells;

    protected CompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, ColumnTracker columnTracker, long readPointToUse, long oldestUnexpiredTS, long now) {
        super(CompactionScanQueryMatcher.createStartKeyFromRow(HConstants.EMPTY_START_ROW, scanInfo), scanInfo, columnTracker, oldestUnexpiredTS, now);
        this.maxReadPointToTrackVersions = readPointToUse;
        this.deletes = deletes;
        this.keepDeletedCells = scanInfo.getKeepDeletedCells();
    }

    @Override
    public void beforeShipped() throws IOException {
        super.beforeShipped();
        this.deletes.beforeShipped();
    }

    @Override
    public boolean hasNullColumnInQuery() {
        return true;
    }

    @Override
    public boolean isUserScan() {
        return false;
    }

    @Override
    public boolean moreRowsMayExistAfter(Cell cell) {
        return true;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public Cell getNextKeyHint(Cell cell) throws IOException {
        return null;
    }

    @Override
    protected void reset() {
        this.deletes.reset();
    }

    protected final void trackDelete(Cell cell) {
        if (this.keepDeletedCells == KeepDeletedCells.FALSE || this.keepDeletedCells == KeepDeletedCells.TTL && cell.getTimestamp() < this.oldestUnexpiredTS) {
            this.deletes.add(cell);
        }
    }

    public static CompactionScanQueryMatcher create(ScanInfo scanInfo, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, byte[] dropDeletesFromRow, byte[] dropDeletesToRow, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        Pair<DeleteTracker, ColumnTracker> trackers = CompactionScanQueryMatcher.getTrackers(regionCoprocessorHost, null, scanInfo, oldestUnexpiredTS, null);
        DeleteTracker deleteTracker = trackers.getFirst();
        ColumnTracker columnTracker = trackers.getSecond();
        if (dropDeletesFromRow == null) {
            if (scanType == ScanType.COMPACT_RETAIN_DELETES) {
                if (scanInfo.isNewVersionBehavior()) {
                    return new IncludeAllCompactionQueryMatcher(scanInfo, deleteTracker, columnTracker, readPointToUse, oldestUnexpiredTS, now);
                }
                return new MinorCompactionScanQueryMatcher(scanInfo, deleteTracker, columnTracker, readPointToUse, oldestUnexpiredTS, now);
            }
            return new MajorCompactionScanQueryMatcher(scanInfo, deleteTracker, columnTracker, readPointToUse, earliestPutTs, oldestUnexpiredTS, now);
        }
        return new StripeCompactionScanQueryMatcher(scanInfo, deleteTracker, columnTracker, readPointToUse, earliestPutTs, oldestUnexpiredTS, now, dropDeletesFromRow, dropDeletesToRow);
    }
}

