/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedKeyValueHeap
extends KeyValueHeap {
    public ReversedKeyValueHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
        super(scanners, new ReversedKVScannerComparator(comparator));
    }

    @Override
    public boolean seek(Cell seekKey) throws IOException {
        throw new IllegalStateException("seek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean reseek(Cell seekKey) throws IOException {
        throw new IllegalStateException("reseek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean requestSeek(Cell key, boolean forward, boolean useBloom) throws IOException {
        throw new IllegalStateException("requestSeek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean seekToPreviousRow(Cell seekKey) throws IOException {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = (KeyValueScanner)this.heap.poll()) != null) {
            Cell topKey = scanner.peek();
            if (this.comparator.getComparator().compareRows(topKey, seekKey) < 0) {
                this.heap.add(scanner);
                this.current = this.pollRealKV();
                return this.current != null;
            }
            if (!scanner.seekToPreviousRow(seekKey)) {
                this.scannersForDelayedClose.add(scanner);
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    @Override
    public boolean backwardSeek(Cell seekKey) throws IOException {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = (KeyValueScanner)this.heap.poll()) != null) {
            Cell topKey = scanner.peek();
            if (CellUtil.matchingRows(seekKey, topKey) && this.comparator.getComparator().compare(seekKey, topKey) <= 0 || this.comparator.getComparator().compareRows(seekKey, topKey) > 0) {
                this.heap.add(scanner);
                this.current = this.pollRealKV();
                return this.current != null;
            }
            if (!scanner.backwardSeek(seekKey)) {
                this.scannersForDelayedClose.add(scanner);
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    @Override
    public Cell next() throws IOException {
        if (this.current == null) {
            return null;
        }
        Cell kvReturn = this.current.next();
        Cell kvNext = this.current.peek();
        if (kvNext == null || this.comparator.kvComparator.compareRows(kvNext, kvReturn) > 0) {
            if (this.current.seekToPreviousRow(kvReturn)) {
                this.heap.add(this.current);
            } else {
                this.scannersForDelayedClose.add(this.current);
            }
            this.current = null;
            this.current = this.pollRealKV();
        } else {
            KeyValueScanner topScanner = (KeyValueScanner)this.heap.peek();
            if (topScanner != null && this.comparator.compare(this.current, topScanner) > 0) {
                this.heap.add(this.current);
                this.current = null;
                this.current = this.pollRealKV();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        throw new NotImplementedException("Not implemented");
    }

    private static class ReversedKVScannerComparator
    extends KeyValueHeap.KVScannerComparator {
        public ReversedKVScannerComparator(CellComparator kvComparator) {
            super(kvComparator);
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            int rowComparison = this.compareRows(left.peek(), right.peek());
            if (rowComparison != 0) {
                return -rowComparison;
            }
            return super.compare(left, right);
        }

        public int compareRows(Cell left, Cell right) {
            return this.kvComparator.compareRows(left, right);
        }
    }
}

