/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.metrics;

import org.apache.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.ExceptionTrackingSource;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ExceptionTrackingSourceImpl
extends BaseSourceImpl
implements ExceptionTrackingSource {
    protected MutableFastCounter exceptions;
    protected MutableFastCounter exceptionsOOO;
    protected MutableFastCounter exceptionsBusy;
    protected MutableFastCounter exceptionsUnknown;
    protected MutableFastCounter exceptionsScannerReset;
    protected MutableFastCounter exceptionsSanity;
    protected MutableFastCounter exceptionsNSRE;
    protected MutableFastCounter exceptionsMoved;
    protected MutableFastCounter exceptionsMultiTooLarge;
    protected MutableFastCounter exceptionsCallQueueTooBig;
    protected MutableFastCounter exceptionsQuotaExceeded;
    protected MutableFastCounter exceptionsRpcThrottling;
    protected MutableFastCounter exceptionRequestTooBig;
    protected MutableFastCounter otherExceptions;

    public ExceptionTrackingSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.exceptions = this.getMetricsRegistry().newCounter("exceptions", "Exceptions caused by requests", 0L);
        this.exceptionsOOO = this.getMetricsRegistry().newCounter("exceptions.OutOfOrderScannerNextException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsBusy = this.getMetricsRegistry().newCounter("exceptions.RegionTooBusyException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsUnknown = this.getMetricsRegistry().newCounter("exceptions.UnknownScannerException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsScannerReset = this.getMetricsRegistry().newCounter("exceptions.ScannerResetException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsSanity = this.getMetricsRegistry().newCounter("exceptions.FailedSanityCheckException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMoved = this.getMetricsRegistry().newCounter("exceptions.RegionMovedException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsNSRE = this.getMetricsRegistry().newCounter("exceptions.NotServingRegionException", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsMultiTooLarge = this.getMetricsRegistry().newCounter("exceptions.multiResponseTooLarge", "A response to a multi request was too large and the rest of the requests will have to be retried.", 0L);
        this.exceptionsCallQueueTooBig = this.getMetricsRegistry().newCounter("exceptions.callQueueTooBig", "Call queue is full", 0L);
        this.exceptionsQuotaExceeded = this.getMetricsRegistry().newCounter("exceptions.quotaExceeded", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionsRpcThrottling = this.getMetricsRegistry().newCounter("exceptions.rpcThrottling", "Number of requests that resulted in the specified type of Exception", 0L);
        this.exceptionRequestTooBig = this.getMetricsRegistry().newCounter("exceptions.requestTooBig", "Number of requests that resulted in the specified type of Exception", 0L);
        this.otherExceptions = this.getMetricsRegistry().newCounter("exceptions.otherExceptions", "Number of requests that resulted in the specified type of Exception", 0L);
    }

    @Override
    public void exception() {
        this.exceptions.incr();
    }

    @Override
    public void outOfOrderException() {
        this.exceptionsOOO.incr();
    }

    @Override
    public void failedSanityException() {
        this.exceptionsSanity.incr();
    }

    @Override
    public void movedRegionException() {
        this.exceptionsMoved.incr();
    }

    @Override
    public void notServingRegionException() {
        this.exceptionsNSRE.incr();
    }

    @Override
    public void unknownScannerException() {
        this.exceptionsUnknown.incr();
    }

    @Override
    public void scannerResetException() {
        this.exceptionsScannerReset.incr();
    }

    @Override
    public void tooBusyException() {
        this.exceptionsBusy.incr();
    }

    @Override
    public void multiActionTooLargeException() {
        this.exceptionsMultiTooLarge.incr();
    }

    @Override
    public void callQueueTooBigException() {
        this.exceptionsCallQueueTooBig.incr();
    }

    @Override
    public void quotaExceededException() {
        this.exceptionsQuotaExceeded.incr();
    }

    @Override
    public void rpcThrottlingException() {
        this.exceptionsRpcThrottling.incr();
    }

    @Override
    public void requestTooBigException() {
        this.exceptionRequestTooBig.incr();
    }

    @Override
    public void otherExceptions() {
        this.otherExceptions.incr();
    }
}

