/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractPeerProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements PeerProcedureInterface {
    protected String peerId;
    protected ProcedurePrepareLatch latch;

    protected AbstractPeerProcedure() {
    }

    protected AbstractPeerProcedure(String peerId) {
        this.peerId = peerId;
        this.latch = ProcedurePrepareLatch.createLatch(2, 0);
    }

    public ProcedurePrepareLatch getLatch() {
        return this.latch;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized((Procedure<?>)this);
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitPeerExclusiveLock((Procedure<?>)this, this.peerId)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakePeerExclusiveLock((Procedure<?>)this, this.peerId);
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.PeerProcedureStateData.newBuilder().setPeerId(this.peerId).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        this.peerId = ((MasterProcedureProtos.PeerProcedureStateData)serializer.deserialize(MasterProcedureProtos.PeerProcedureStateData.class)).getPeerId();
    }
}

