/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.balancer;

import java.io.InterruptedIOException;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClusterStatusChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStatusChore.class);
    private final HMaster master;
    private final LoadBalancer balancer;

    public ClusterStatusChore(HMaster master, LoadBalancer balancer) {
        super(master.getServerName() + "-ClusterStatusChore", master, master.getConfiguration().getInt("hbase.balancer.statusPeriod", 60000));
        this.master = master;
        this.balancer = balancer;
    }

    @Override
    protected void chore() {
        try {
            this.balancer.setClusterMetrics(this.master.getClusterMetricsWithoutCoprocessor());
        }
        catch (InterruptedIOException e) {
            LOG.warn("Ignoring interruption", (Throwable)e);
        }
    }
}

