/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SplitOrMergeTracker {
    private String splitZnode;
    private String mergeZnode;
    private SwitchStateTracker splitStateTracker;
    private SwitchStateTracker mergeStateTracker;

    public SplitOrMergeTracker(ZKWatcher watcher, Configuration conf, Abortable abortable) {
        try {
            if (ZKUtil.checkExists((ZKWatcher)watcher, (String)watcher.getZNodePaths().switchZNode) < 0) {
                ZKUtil.createAndFailSilent((ZKWatcher)watcher, (String)watcher.getZNodePaths().switchZNode);
            }
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        this.splitZnode = ZNodePaths.joinZNode(watcher.getZNodePaths().switchZNode, conf.get("zookeeper.znode.switch.split", "split"));
        this.mergeZnode = ZNodePaths.joinZNode(watcher.getZNodePaths().switchZNode, conf.get("zookeeper.znode.switch.merge", "merge"));
        this.splitStateTracker = new SwitchStateTracker(watcher, this.splitZnode, abortable);
        this.mergeStateTracker = new SwitchStateTracker(watcher, this.mergeZnode, abortable);
    }

    public void start() {
        this.splitStateTracker.start();
        this.mergeStateTracker.start();
    }

    public boolean isSplitOrMergeEnabled(MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return this.splitStateTracker.isSwitchEnabled();
            }
            case MERGE: {
                return this.mergeStateTracker.isSwitchEnabled();
            }
        }
        return false;
    }

    public void setSplitOrMergeEnabled(boolean enabled, MasterSwitchType switchType) throws KeeperException {
        switch (switchType) {
            case SPLIT: {
                this.splitStateTracker.setSwitchEnabled(enabled);
                break;
            }
            case MERGE: {
                this.mergeStateTracker.setSwitchEnabled(enabled);
                break;
            }
        }
    }

    private static class SwitchStateTracker
    extends ZKNodeTracker {
        public SwitchStateTracker(ZKWatcher watcher, String node, Abortable abortable) {
            super(watcher, node, abortable);
        }

        public boolean isSwitchEnabled() {
            byte[] upData = super.getData(false);
            try {
                return upData == null || this.parseFrom(upData).getEnabled();
            }
            catch (DeserializationException dex) {
                LOG.error("ZK state for LoadBalancer could not be parsed " + Bytes.toStringBinary(upData));
                return false;
            }
        }

        public void setSwitchEnabled(boolean enabled) throws KeeperException {
            byte[] upData = this.toByteArray(enabled);
            try {
                ZKUtil.setData((ZKWatcher)this.watcher, (String)this.node, (byte[])upData);
            }
            catch (KeeperException.NoNodeException nne) {
                ZKUtil.createAndWatch((ZKWatcher)this.watcher, (String)this.node, (byte[])upData);
            }
            super.nodeDataChanged(this.node);
        }

        private byte[] toByteArray(boolean enabled) {
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            builder.setEnabled(enabled);
            return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
        }

        private ZooKeeperProtos.SwitchState parseFrom(byte[] bytes) throws DeserializationException {
            ProtobufUtil.expectPBMagicPrefix(bytes);
            ZooKeeperProtos.SwitchState.Builder builder = ZooKeeperProtos.SwitchState.newBuilder();
            try {
                int magicLen = ProtobufUtil.lengthOfPBMagic();
                ProtobufUtil.mergeFrom(builder, bytes, magicLen, bytes.length - magicLen);
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return builder.build();
        }
    }
}

