/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hudi.org.apache.hadoop.hbase.util.Addressing;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MasterRedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 2894774810058302473L;
    private static final Logger LOG = LoggerFactory.getLogger(MasterRedirectServlet.class);
    private final int regionServerInfoPort;
    private final String regionServerHostname;

    public MasterRedirectServlet(InfoServer infoServer, String hostname) {
        this.regionServerInfoPort = infoServer.getPort();
        this.regionServerHostname = hostname;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectHost = this.regionServerHostname;
        if (redirectHost == null && !Addressing.isLocalAddress(InetAddress.getByName(redirectHost = request.getServerName()))) {
            LOG.warn("Couldn't resolve '" + redirectHost + "' as an address local to this node and '" + "hbase.master.hostname" + "' is not set; client will get an HTTP 400 response. If your HBase deployment relies on client accessible names that the region server process can't resolve locally, then you should set the previously mentioned configuration variable to an appropriate hostname.");
            response.sendError(400, "Request was to a host that I can't resolve for any of the network interfaces on this node. If this is due to an intermediary such as an HTTP load balancer or other proxy, your HBase administrator can set 'hbase.master.hostname' to point to the correct hostname.");
            return;
        }
        String redirectUrl = request.getScheme() + "://" + redirectHost + ":" + this.regionServerInfoPort + request.getRequestURI();
        response.sendRedirect(redirectUrl);
    }
}

