/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hudi.org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnValueFilter
extends FilterBase {
    private final byte[] family;
    private final byte[] qualifier;
    private final CompareOperator op;
    private final ByteArrayComparable comparator;
    private boolean columnFound = false;

    public ColumnValueFilter(byte[] family, byte[] qualifier, CompareOperator op, byte[] value) {
        this(family, qualifier, op, new BinaryComparator(value));
    }

    public ColumnValueFilter(byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator) {
        this.family = Preconditions.checkNotNull(family, "family should not be null.");
        this.qualifier = qualifier == null ? new byte[]{} : qualifier;
        this.op = Preconditions.checkNotNull(op, "CompareOperator should not be null");
        this.comparator = Preconditions.checkNotNull(comparator, "Comparator should not be null");
    }

    public CompareOperator getCompareOperator() {
        return this.op;
    }

    public ByteArrayComparable getComparator() {
        return this.comparator;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    @Override
    public void reset() throws IOException {
        this.columnFound = false;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        if (!CellUtil.matchingColumn(c, this.family, this.qualifier)) {
            return this.columnFound ? Filter.ReturnCode.NEXT_ROW : Filter.ReturnCode.NEXT_COL;
        }
        this.columnFound = true;
        return this.compareValue(this.getCompareOperator(), this.getComparator(), c) ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
    }

    private boolean compareValue(CompareOperator op, ByteArrayComparable comparator, Cell cell) {
        if (op == CompareOperator.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareValue(cell, comparator);
        return CompareFilter.compare(op, compareResult);
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 4, "Expect 4 arguments: %s", filterArguments.size());
        byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
        CompareOperator operator = ParseFilter.createCompareOperator(filterArguments.get(2));
        ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(3)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && operator != CompareOperator.EQUAL && operator != CompareOperator.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        return new ColumnValueFilter(family, qualifier, operator, comparator);
    }

    FilterProtos.ColumnValueFilter convert() {
        FilterProtos.ColumnValueFilter.Builder builder = FilterProtos.ColumnValueFilter.newBuilder();
        builder.setFamily(UnsafeByteOperations.unsafeWrap(this.family));
        builder.setQualifier(UnsafeByteOperations.unsafeWrap(this.qualifier));
        builder.setCompareOp(HBaseProtos.CompareType.valueOf(this.op.name()));
        builder.setComparator(ProtobufUtil.toComparator(this.comparator));
        return builder.build();
    }

    public static ColumnValueFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        ByteArrayComparable comparator;
        FilterProtos.ColumnValueFilter proto;
        try {
            proto = FilterProtos.ColumnValueFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareOperator compareOp = CompareOperator.valueOf(proto.getCompareOp().name());
        try {
            comparator = ProtobufUtil.toComparator(proto.getComparator());
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new ColumnValueFilter(proto.getFamily().toByteArray(), proto.getQualifier().toByteArray(), compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return this.convert().toByteArray();
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnValueFilter)) {
            return false;
        }
        ColumnValueFilter other = (ColumnValueFilter)o;
        return Bytes.equals(this.getFamily(), other.getFamily()) && Bytes.equals(this.getQualifier(), other.getQualifier()) && this.getCompareOperator().equals((Object)other.getCompareOperator()) && this.getComparator().areSerializedFieldsEqual(other.getComparator());
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        return Bytes.equals(name, this.family);
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.toStringBinary(this.family), Bytes.toStringBinary(this.qualifier), this.op.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Bytes.hashCode(this.getFamily()), Bytes.hashCode(this.getQualifier()), this.getCompareOperator(), this.getComparator()});
    }
}

