/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.favored;

import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.util.Addressing;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class StartcodeAgnosticServerName
extends ServerName {
    public StartcodeAgnosticServerName(String hostname, int port, long startcode) {
        super(hostname, port, startcode);
    }

    public static StartcodeAgnosticServerName valueOf(ServerName serverName) {
        return new StartcodeAgnosticServerName(serverName.getHostname(), serverName.getPort(), serverName.getStartcode());
    }

    public static StartcodeAgnosticServerName valueOf(String hostnameAndPort, long startcode) {
        return new StartcodeAgnosticServerName(Addressing.parseHostname(hostnameAndPort), Addressing.parsePort(hostnameAndPort), startcode);
    }

    public static StartcodeAgnosticServerName valueOf(HostAndPort hostnameAndPort, long startcode) {
        return new StartcodeAgnosticServerName(hostnameAndPort.getHost(), hostnameAndPort.getPort(), startcode);
    }

    @Override
    public int compareTo(ServerName other) {
        int compare = this.getHostname().compareTo(other.getHostname());
        if (compare != 0) {
            return compare;
        }
        compare = this.getPort() - other.getPort();
        if (compare != 0) {
            return compare;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return this.getAddress().hashCode();
    }
}

