/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellScannable;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.Cursor;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Result
implements CellScannable,
CellScanner {
    private Cell[] cells;
    private Boolean exists;
    private boolean stale = false;
    private boolean mayHaveMoreCellsInRow = false;
    private transient byte[] row = null;
    private transient NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyMap = null;
    private static ThreadLocal<byte[]> localBuffer = new ThreadLocal();
    private static final int PAD_WIDTH = 128;
    public static final Result EMPTY_RESULT = new Result(true);
    private static final int INITIAL_CELLSCANNER_INDEX = -1;
    private int cellScannerIndex = -1;
    private RegionLoadStats stats;
    private final boolean readonly;
    private Cursor cursor = null;

    public Result() {
        this(false);
    }

    private Result(boolean readonly) {
        this.readonly = readonly;
    }

    public static Result create(List<Cell> cells) {
        return Result.create(cells, null);
    }

    public static Result create(List<Cell> cells, Boolean exists) {
        return Result.create(cells, exists, false);
    }

    public static Result create(List<Cell> cells, Boolean exists, boolean stale) {
        return Result.create(cells, exists, stale, false);
    }

    public static Result create(List<Cell> cells, Boolean exists, boolean stale, boolean mayHaveMoreCellsInRow) {
        if (exists != null) {
            return new Result(null, exists, stale, mayHaveMoreCellsInRow);
        }
        return new Result(cells.toArray(new Cell[cells.size()]), null, stale, mayHaveMoreCellsInRow);
    }

    public static Result create(Cell[] cells) {
        return Result.create(cells, null, false);
    }

    public static Result create(Cell[] cells, Boolean exists, boolean stale) {
        return Result.create(cells, exists, stale, false);
    }

    public static Result create(Cell[] cells, Boolean exists, boolean stale, boolean mayHaveMoreCellsInRow) {
        if (exists != null) {
            return new Result(null, exists, stale, mayHaveMoreCellsInRow);
        }
        return new Result(cells, null, stale, mayHaveMoreCellsInRow);
    }

    public static Result createCursorResult(Cursor cursor) {
        return new Result(cursor);
    }

    private Result(Cursor cursor) {
        this.cursor = cursor;
        this.readonly = false;
    }

    private Result(Cell[] cells, Boolean exists, boolean stale, boolean mayHaveMoreCellsInRow) {
        this.cells = cells;
        this.exists = exists;
        this.stale = stale;
        this.mayHaveMoreCellsInRow = mayHaveMoreCellsInRow;
        this.readonly = false;
    }

    public byte[] getRow() {
        if (this.row == null) {
            this.row = this.cells == null || this.cells.length == 0 ? null : CellUtil.cloneRow(this.cells[0]);
        }
        return this.row;
    }

    public Cell[] rawCells() {
        return this.cells;
    }

    public List<Cell> listCells() {
        return this.isEmpty() ? null : Arrays.asList(this.rawCells());
    }

    public List<Cell> getColumnCells(byte[] family, byte[] qualifier) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return result;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return result;
        }
        for (int i = pos; i < kvs.length && CellUtil.matchingColumn(kvs[i], family, qualifier); ++i) {
            result.add(kvs[i]);
        }
        return result;
    }

    private byte[] notNullBytes(byte[] bytes) {
        if (bytes == null) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        return bytes;
    }

    protected int binarySearch(Cell[] kvs, byte[] family, byte[] qualifier) {
        byte[] familyNotNull = this.notNullBytes(family);
        byte[] qualifierNotNull = this.notNullBytes(qualifier);
        Cell searchTerm = PrivateCellUtil.createFirstOnRow(kvs[0].getRowArray(), kvs[0].getRowOffset(), kvs[0].getRowLength(), familyNotNull, 0, (byte)familyNotNull.length, qualifierNotNull, 0, qualifierNotNull.length);
        int pos = Arrays.binarySearch(kvs, searchTerm, CellComparator.getInstance());
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    protected int binarySearch(Cell[] kvs, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue searchTerm;
        int pos;
        double keyValueSize = KeyValue.getKeyValueDataStructureSize(kvs[0].getRowLength(), flength, qlength, 0);
        byte[] buffer = localBuffer.get();
        if (buffer == null || keyValueSize > (double)buffer.length) {
            buffer = new byte[(int)Math.ceil(keyValueSize / 128.0) * 128];
            localBuffer.set(buffer);
        }
        if ((pos = Arrays.binarySearch(kvs, searchTerm = KeyValueUtil.createFirstOnRow(buffer, 0, kvs[0].getRowArray(), kvs[0].getRowOffset(), kvs[0].getRowLength(), family, foffset, flength, qualifier, qoffset, qlength), CellComparator.getInstance())) < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    public Cell getColumnLatestCell(byte[] family, byte[] qualifier) {
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return null;
        }
        if (CellUtil.matchingColumn(kvs[pos], family, qualifier)) {
            return kvs[pos];
        }
        return null;
    }

    public Cell getColumnLatestCell(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, foffset, flength, qualifier, qoffset, qlength);
        if (pos == -1) {
            return null;
        }
        if (PrivateCellUtil.matchingColumn(kvs[pos], family, foffset, flength, qualifier, qoffset, qlength)) {
            return kvs[pos];
        }
        return null;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, qualifier);
        if (kv == null) {
            return null;
        }
        return CellUtil.cloneValue(kv);
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, 0, family.length, qualifier, 0, qualifier.length);
        if (kv == null) {
            return null;
        }
        return ByteBuffer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()).asReadOnlyBuffer();
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return null;
        }
        return ByteBuffer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()).asReadOnlyBuffer();
    }

    public boolean loadValue(byte[] family, byte[] qualifier, ByteBuffer dst) throws BufferOverflowException {
        return this.loadValue(family, 0, family.length, qualifier, 0, qualifier.length, dst);
    }

    public boolean loadValue(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, ByteBuffer dst) throws BufferOverflowException {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return false;
        }
        dst.put(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }

    public boolean containsNonEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsNonEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsNonEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() > 0;
    }

    public boolean containsEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() == 0;
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, qualifier);
        return kv != null;
    }

    public boolean containsColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength) != null;
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyMap != null) {
            return this.familyMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (Cell kv : this.cells) {
            byte[] qualifier;
            TreeMap<Long, byte[]> versionMap;
            byte[] family = CellUtil.cloneFamily(kv);
            TreeMap columnMap = (TreeMap)this.familyMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap(Bytes.BYTES_COMPARATOR);
                this.familyMap.put(family, columnMap);
            }
            if ((versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier = CellUtil.cloneQualifier(kv))) == null) {
                versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                columnMap.put(qualifier, versionMap);
            }
            Long timestamp = kv.getTimestamp();
            byte[] value = CellUtil.cloneValue(kv);
            versionMap.put(timestamp, value);
        }
        return this.familyMap;
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getNoVersionMap() {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], NavigableMap<byte[], byte[]>> returnMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyEntry : this.familyMap.entrySet()) {
            TreeMap<byte[], byte[]> qualifierMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                byte[] value = (byte[])((NavigableMap)qualifierEntry.getValue()).get(((NavigableMap)qualifierEntry.getValue()).firstKey());
                qualifierMap.put((byte[])qualifierEntry.getKey(), value);
            }
            returnMap.put((byte[])familyEntry.getKey(), (NavigableMap<byte[], byte[]>)qualifierMap);
        }
        return returnMap;
    }

    public NavigableMap<byte[], byte[]> getFamilyMap(byte[] family) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], byte[]> returnMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return returnMap;
        }
        for (Map.Entry entry : qualifierMap.entrySet()) {
            byte[] value = (byte[])((NavigableMap)entry.getValue()).get(((NavigableMap)entry.getValue()).firstKey());
            returnMap.put((byte[])entry.getKey(), value);
        }
        return returnMap;
    }

    public byte[] value() {
        if (this.isEmpty()) {
            return null;
        }
        return CellUtil.cloneValue(this.cells[0]);
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int size() {
        return this.cells == null ? 0 : this.cells.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell kv : this.cells) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static void compareResults(Result res1, Result res2) throws Exception {
        Result.compareResults(res1, res2, true);
    }

    public static void compareResults(Result res1, Result res2, boolean verbose) throws Exception {
        if (res2 == null) {
            throw new Exception("There wasn't enough rows, we stopped at " + Bytes.toStringBinary(res1.getRow()));
        }
        if (res1.size() != res2.size()) {
            if (verbose) {
                throw new Exception("This row doesn't have the same number of KVs: " + res1 + " compared to " + res2);
            }
            throw new Exception("This row doesn't have the same number of KVs: row=" + Bytes.toStringBinary(res1.getRow()) + ", " + res1.size() + " cells are compared to " + res2.size() + " cells");
        }
        Cell[] ourKVs = res1.rawCells();
        Cell[] replicatedKVs = res2.rawCells();
        for (int i = 0; i < res1.size(); ++i) {
            if (ourKVs[i].equals(replicatedKVs[i]) && CellUtil.matchingValue(ourKVs[i], replicatedKVs[i]) && CellUtil.matchingTags(ourKVs[i], replicatedKVs[i])) continue;
            if (verbose) {
                throw new Exception("This result was different: " + res1 + " compared to " + res2);
            }
            throw new Exception("This result was different: row=" + Bytes.toStringBinary(res1.getRow()));
        }
    }

    public static Result createCompleteResult(Iterable<Result> partialResults) throws IOException {
        if (partialResults == null) {
            return Result.create(Collections.emptyList(), null, false);
        }
        ArrayList<Cell> cells = new ArrayList<Cell>();
        boolean stale = false;
        byte[] prevRow = null;
        byte[] currentRow = null;
        Iterator<Result> iter = partialResults.iterator();
        while (iter.hasNext()) {
            Result r = iter.next();
            currentRow = r.getRow();
            if (prevRow != null && !Bytes.equals(prevRow, currentRow)) {
                throw new IOException("Cannot form complete result. Rows of partial results do not match. Partial Results: " + partialResults);
            }
            if (iter.hasNext() && !r.mayHaveMoreCellsInRow()) {
                throw new IOException("Cannot form complete result. Result is missing partial flag. Partial Results: " + partialResults);
            }
            prevRow = currentRow;
            stale = stale || r.isStale();
            for (Cell c : r.rawCells()) {
                cells.add(c);
            }
        }
        return Result.create(cells, null, stale);
    }

    public static long getTotalSizeOfCells(Result result) {
        long size = 0L;
        if (result.isEmpty()) {
            return size;
        }
        for (Cell c : result.rawCells()) {
            size += c.heapSize();
        }
        return size;
    }

    public void copyFrom(Result other) {
        this.checkReadonly();
        this.row = null;
        this.familyMap = null;
        this.cells = other.cells;
    }

    @Override
    public CellScanner cellScanner() {
        this.cellScannerIndex = -1;
        return this;
    }

    @Override
    public Cell current() {
        if (this.isEmpty() || this.cellScannerIndex == -1 || this.cellScannerIndex >= this.cells.length) {
            return null;
        }
        return this.cells[this.cellScannerIndex];
    }

    @Override
    public boolean advance() {
        if (this.isEmpty()) {
            return false;
        }
        ++this.cellScannerIndex;
        if (this.cellScannerIndex < this.cells.length) {
            return true;
        }
        if (this.cellScannerIndex == this.cells.length) {
            return false;
        }
        throw new NoSuchElementException("Cannot advance beyond the last cell");
    }

    public Boolean getExists() {
        return this.exists;
    }

    public void setExists(Boolean exists) {
        this.checkReadonly();
        this.exists = exists;
    }

    public boolean isStale() {
        return this.stale;
    }

    @Deprecated
    public boolean isPartial() {
        return this.mayHaveMoreCellsInRow;
    }

    public boolean mayHaveMoreCellsInRow() {
        return this.mayHaveMoreCellsInRow;
    }

    @InterfaceAudience.Private
    public void setStatistics(RegionLoadStats loadStats) {
        this.stats = loadStats;
    }

    public RegionLoadStats getStats() {
        return this.stats;
    }

    private void checkReadonly() {
        if (this.readonly) {
            throw new UnsupportedOperationException("Attempting to modify readonly EMPTY_RESULT!");
        }
    }

    public boolean isCursor() {
        return this.cursor != null;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

