/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.IndividualBytesFieldCell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Put
extends Mutation
implements HeapSize {
    public Put(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] row, long ts) {
        this(row, 0, row.length, ts);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength) {
        this(rowArray, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Put(ByteBuffer row, long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        Put.checkRow(row);
        this.row = new byte[row.remaining()];
        row.get(this.row);
        this.ts = ts;
    }

    public Put(ByteBuffer row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Put.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
        this.ts = ts;
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
    }

    public Put(byte[] row, boolean rowIsImmutable) {
        this(row, Long.MAX_VALUE, rowIsImmutable);
    }

    public Put(byte[] row, long ts, boolean rowIsImmutable) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        this.ts = ts;
        Put.checkRow(row);
        this.row = rowIsImmutable ? row : Bytes.copy(row, 0, row.length);
    }

    public Put(Put putToCopy) {
        super(putToCopy);
    }

    public Put(byte[] row, long ts, NavigableMap<byte[], List<Cell>> familyMap) {
        super(row, ts, familyMap);
    }

    public Put addColumn(byte[] family, byte[] qualifier, byte[] value) {
        return this.addColumn(family, qualifier, this.ts, value);
    }

    @Deprecated
    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value) {
        return this.addImmutable(family, qualifier, this.ts, value);
    }

    public Put addColumn(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add(kv);
        return this;
    }

    @Deprecated
    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (family == null) {
            throw new IllegalArgumentException("Family cannot be null");
        }
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        list.add(new IndividualBytesFieldCell(this.row, family, qualifier, ts, KeyValue.Type.Put, value));
        return this;
    }

    public Put addColumn(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add(kv);
        return this;
    }

    @Deprecated
    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add(kv);
        return this;
    }

    @Override
    public Put add(Cell cell) throws IOException {
        super.add(cell);
        return this;
    }

    @Override
    public Put setTimestamp(long timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public Put setAttribute(String name, byte[] value) {
        return (Put)super.setAttribute(name, value);
    }

    @Override
    public Put setId(String id) {
        return (Put)super.setId(id);
    }

    @Override
    public Put setDurability(Durability d) {
        return (Put)super.setDurability(d);
    }

    @Override
    @Deprecated
    public Put setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Put)super.setFamilyCellMap(map);
    }

    @Override
    public Put setClusterIds(List<UUID> clusterIds) {
        return (Put)super.setClusterIds(clusterIds);
    }

    @Override
    public Put setCellVisibility(CellVisibility expression) {
        return (Put)super.setCellVisibility(expression);
    }

    @Override
    public Put setACL(String user, Permission perms) {
        return (Put)super.setACL(user, perms);
    }

    @Override
    public Put setACL(Map<String, Permission> perms) {
        return (Put)super.setACL(perms);
    }

    @Override
    public Put setTTL(long ttl) {
        return (Put)super.setTTL(ttl);
    }

    @Override
    public Put setPriority(int priority) {
        return (Put)super.setPriority(priority);
    }
}

