/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterAddressRefresher
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MasterAddressRefresher.class);
    public static final String PERIODIC_REFRESH_INTERVAL_SECS = "hbase.client.master_registry.refresh_interval_secs";
    private static final int PERIODIC_REFRESH_INTERVAL_SECS_DEFAULT = 300;
    public static final String MIN_SECS_BETWEEN_REFRESHES = "hbase.client.master_registry.min_secs_between_refreshes";
    private static final int MIN_SECS_BETWEEN_REFRESHES_DEFAULT = 60;
    private final ExecutorService pool;
    private final MasterRegistry registry;
    private final long periodicRefreshMs;
    private final long timeBetweenRefreshesMs;
    private final Object refreshMasters = new Object();

    @Override
    public void close() {
        this.pool.shutdownNow();
    }

    MasterAddressRefresher(Configuration conf, MasterRegistry registry) {
        this.pool = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("master-registry-refresh-end-points").setDaemon(true).build());
        this.periodicRefreshMs = TimeUnit.SECONDS.toMillis(conf.getLong(PERIODIC_REFRESH_INTERVAL_SECS, 300L));
        this.timeBetweenRefreshesMs = TimeUnit.SECONDS.toMillis(conf.getLong(MIN_SECS_BETWEEN_REFRESHES, 60L));
        Preconditions.checkArgument(this.periodicRefreshMs > 0L);
        Preconditions.checkArgument(this.timeBetweenRefreshesMs < this.periodicRefreshMs);
        this.registry = registry;
        this.pool.submit(new RefreshThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNow() {
        Object object = this.refreshMasters;
        synchronized (object) {
            this.refreshMasters.notify();
        }
    }

    private class RefreshThread
    implements Runnable {
        private RefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long lastRpcTs = 0L;
            while (!Thread.interrupted()) {
                try {
                    Object object = MasterAddressRefresher.this.refreshMasters;
                    synchronized (object) {
                        MasterAddressRefresher.this.refreshMasters.wait(MasterAddressRefresher.this.periodicRefreshMs);
                    }
                    long currentTs = EnvironmentEdgeManager.currentTime();
                    if (lastRpcTs != 0L && currentTs - lastRpcTs <= MasterAddressRefresher.this.timeBetweenRefreshesMs) continue;
                    lastRpcTs = currentTs;
                    LOG.debug("Attempting to refresh master address end points.");
                    HashSet<ServerName> newMasters = new HashSet<ServerName>((Collection)MasterAddressRefresher.this.registry.getMasters().get());
                    MasterAddressRefresher.this.registry.populateMasterStubs(newMasters);
                    LOG.debug("Finished refreshing master end points. {}", newMasters);
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted during wait, aborting refresh-masters-thread.", (Throwable)e);
                    break;
                }
                catch (IOException | ExecutionException e) {
                    LOG.debug("Error populating latest list of masters.", (Throwable)e);
                }
            }
            LOG.info("Master end point refresher loop exited.");
        }
    }
}

