/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Delete
extends Mutation {
    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Delete(byte[] row, long timestamp) {
        this(row, 0, row.length, timestamp);
    }

    public Delete(byte[] row, int rowOffset, int rowLength) {
        this(row, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Delete(byte[] row, int rowOffset, int rowLength, long timestamp) {
        Delete.checkRow(row, rowOffset, rowLength);
        this.row = Bytes.copy(row, rowOffset, rowLength);
        this.setTimestamp(timestamp);
    }

    public Delete(Delete deleteToCopy) {
        super(deleteToCopy);
    }

    public Delete(byte[] row, long ts, NavigableMap<byte[], List<Cell>> familyMap) {
        super(row, ts, familyMap);
    }

    @Deprecated
    public Delete addDeleteMarker(Cell kv) throws IOException {
        return this.add(kv);
    }

    @Override
    public Delete add(Cell cell) throws IOException {
        super.add(cell);
        return this;
    }

    public Delete addFamily(byte[] family) {
        this.addFamily(family, this.ts);
        return this;
    }

    public Delete addFamily(byte[] family, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        List<Cell> list = this.getCellList(family);
        if (!list.isEmpty()) {
            list.clear();
        }
        KeyValue kv = new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily);
        list.add(kv);
        return this;
    }

    public Delete addFamilyVersion(byte[] family, long timestamp) {
        List<Cell> list = this.getCellList(family);
        list.add(new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamilyVersion));
        return this;
    }

    public Delete addColumns(byte[] family, byte[] qualifier) {
        this.addColumns(family, qualifier, this.ts);
        return this;
    }

    public Delete addColumns(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        List<Cell> list = this.getCellList(family);
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        return this;
    }

    public Delete addColumn(byte[] family, byte[] qualifier) {
        this.addColumn(family, qualifier, this.ts);
        return this;
    }

    public Delete addColumn(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete);
        list.add(kv);
        return this;
    }

    @Override
    public Delete setTimestamp(long timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public Delete setAttribute(String name, byte[] value) {
        return (Delete)super.setAttribute(name, value);
    }

    @Override
    public Delete setId(String id) {
        return (Delete)super.setId(id);
    }

    @Override
    public Delete setDurability(Durability d) {
        return (Delete)super.setDurability(d);
    }

    @Override
    @Deprecated
    public Delete setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Delete)super.setFamilyCellMap(map);
    }

    @Override
    public Delete setClusterIds(List<UUID> clusterIds) {
        return (Delete)super.setClusterIds(clusterIds);
    }

    @Override
    public Delete setCellVisibility(CellVisibility expression) {
        return (Delete)super.setCellVisibility(expression);
    }

    @Override
    public Delete setACL(String user, Permission perms) {
        return (Delete)super.setACL(user, perms);
    }

    @Override
    public Delete setACL(Map<String, Permission> perms) {
        return (Delete)super.setACL(perms);
    }

    @Override
    public Delete setTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Deletes is not supported");
    }

    @Override
    public Delete setPriority(int priority) {
        return (Delete)super.setPriority(priority);
    }
}

