/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.avro.model.HoodieRecordIndexInfo;
import org.apache.hudi.avro.model.HoodieSecondaryIndexInfo;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.util.Lazy;

public class HoodieMetadataPayload
implements HoodieRecordPayload<HoodieMetadataPayload> {
    public static final String KEY_FIELD_NAME = "key";
    public static final String SCHEMA_FIELD_NAME_TYPE = "type";
    public static final String SCHEMA_FIELD_NAME_METADATA = "filesystemMetadata";
    public static final String SCHEMA_FIELD_ID_COLUMN_STATS = "ColumnStatsMetadata";
    public static final String SCHEMA_FIELD_ID_BLOOM_FILTER = "BloomFilterMetadata";
    public static final String SCHEMA_FIELD_ID_RECORD_INDEX = "recordIndexMetadata";
    public static final String SCHEMA_FIELD_ID_SECONDARY_INDEX = "SecondaryIndexMetadata";
    public static final String FIELD_IS_DELETED = "isDeleted";
    public static final String BLOOM_FILTER_FIELD_TYPE = "type";
    public static final String BLOOM_FILTER_FIELD_TIMESTAMP = "timestamp";
    public static final String BLOOM_FILTER_FIELD_BLOOM_FILTER = "bloomFilter";
    public static final String BLOOM_FILTER_FIELD_IS_DELETED = "isDeleted";
    public static final String COLUMN_STATS_FIELD_MIN_VALUE = "minValue";
    public static final String COLUMN_STATS_FIELD_MAX_VALUE = "maxValue";
    public static final String COLUMN_STATS_FIELD_NULL_COUNT = "nullCount";
    public static final String COLUMN_STATS_FIELD_VALUE_COUNT = "valueCount";
    public static final String COLUMN_STATS_FIELD_TOTAL_SIZE = "totalSize";
    public static final String COLUMN_STATS_FIELD_FILE_NAME = "fileName";
    public static final String COLUMN_STATS_FIELD_COLUMN_NAME = "columnName";
    public static final String COLUMN_STATS_FIELD_TOTAL_UNCOMPRESSED_SIZE = "totalUncompressedSize";
    public static final String COLUMN_STATS_FIELD_IS_DELETED = "isDeleted";
    public static final String COLUMN_STATS_FIELD_IS_TIGHT_BOUND = "isTightBound";
    public static final String RECORD_INDEX_FIELD_PARTITION = "partitionName";
    public static final String RECORD_INDEX_FIELD_FILEID_HIGH_BITS = "fileIdHighBits";
    public static final String RECORD_INDEX_FIELD_FILEID_LOW_BITS = "fileIdLowBits";
    public static final String RECORD_INDEX_FIELD_FILE_INDEX = "fileIndex";
    public static final String RECORD_INDEX_FIELD_INSTANT_TIME = "instantTime";
    public static final String RECORD_INDEX_FIELD_FILEID = "fileId";
    public static final String RECORD_INDEX_FIELD_FILEID_ENCODING = "fileIdEncoding";
    public static final int RECORD_INDEX_FIELD_FILEID_ENCODING_UUID = 0;
    public static final int RECORD_INDEX_FIELD_FILEID_ENCODING_RAW_STRING = 1;
    public static final String RECORD_INDEX_FIELD_POSITION = "position";
    public static final int RECORD_INDEX_MISSING_FILEINDEX_FALLBACK = -1;
    public static final String SECONDARY_INDEX_RECORD_KEY_ESCAPE_CHAR = "\\";
    public static final String SECONDARY_INDEX_RECORD_KEY_SEPARATOR = "$";
    public static final String SECONDARY_INDEX_FIELD_IS_DELETED = "isDeleted";
    public static final Lazy<HoodieMetadataColumnStats.Builder> METADATA_COLUMN_STATS_BUILDER_STUB = Lazy.lazily(HoodieMetadataColumnStats::newBuilder);
    private static final HoodieMetadataFileInfo DELETE_FILE_METADATA = new HoodieMetadataFileInfo(0L, true);
    protected String key = null;
    protected int type = 0;
    protected Map<String, HoodieMetadataFileInfo> filesystemMetadata = null;
    protected HoodieMetadataBloomFilter bloomFilterMetadata = null;
    protected HoodieMetadataColumnStats columnStatMetadata = null;
    protected HoodieRecordIndexInfo recordIndexMetadata;
    protected HoodieSecondaryIndexInfo secondaryIndexMetadata;
    private boolean isDeletedRecord = false;

    public HoodieMetadataPayload(@Nullable GenericRecord record, Comparable<?> orderingVal) {
        this(Option.ofNullable(record));
    }

    public HoodieMetadataPayload(Option<GenericRecord> recordOpt) {
        if (recordOpt.isPresent()) {
            GenericRecord record = recordOpt.get();
            this.key = record.get(KEY_FIELD_NAME).toString();
            this.type = (Integer)record.get("type");
            MetadataPartitionType.get(this.type).constructMetadataPayload(this, record);
        } else {
            this.isDeletedRecord = true;
        }
    }

    protected HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        this(key, type, filesystemMetadata, null, null, null, null, false);
    }

    protected HoodieMetadataPayload(String key, HoodieMetadataBloomFilter metadataBloomFilter) {
        this(key, MetadataPartitionType.BLOOM_FILTERS.getRecordType(), null, metadataBloomFilter, null, null, null, metadataBloomFilter.getIsDeleted());
    }

    protected HoodieMetadataPayload(String key, HoodieMetadataColumnStats columnStats, int recordType) {
        this(key, recordType, null, null, columnStats, null, null, columnStats.getIsDeleted());
    }

    private HoodieMetadataPayload(String key, HoodieRecordIndexInfo recordIndexMetadata) {
        this(key, MetadataPartitionType.RECORD_INDEX.getRecordType(), null, null, null, recordIndexMetadata, null, false);
    }

    protected HoodieMetadataPayload(String key, HoodieSecondaryIndexInfo secondaryIndexMetadata) {
        this(key, MetadataPartitionType.SECONDARY_INDEX.getRecordType(), null, null, null, null, secondaryIndexMetadata, secondaryIndexMetadata.getIsDeleted());
    }

    protected HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata, HoodieMetadataBloomFilter metadataBloomFilter, HoodieMetadataColumnStats columnStats, HoodieRecordIndexInfo recordIndexMetadata, HoodieSecondaryIndexInfo secondaryIndexMetadata, boolean isDeletedRecord) {
        this.key = key;
        this.type = type;
        this.filesystemMetadata = filesystemMetadata;
        this.bloomFilterMetadata = metadataBloomFilter;
        this.columnStatMetadata = columnStats;
        this.recordIndexMetadata = recordIndexMetadata;
        this.secondaryIndexMetadata = secondaryIndexMetadata;
        this.isDeletedRecord = isDeletedRecord;
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions) {
        return HoodieMetadataPayload.createPartitionListRecord(partitions, false);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions, boolean isDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        partitions.forEach(partition -> fileInfo.put(HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition(partition), new HoodieMetadataFileInfo(0L, isDeleted)));
        HoodieKey key = new HoodieKey("__all_partitions__", MetadataPartitionType.ALL_PARTITIONS.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), MetadataPartitionType.ALL_PARTITIONS.getRecordType(), fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionFilesRecord(String partition, Map<String, Long> filesAdded, List<String> filesDeleted) {
        String partitionIdentifier = HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition(partition);
        int size = filesAdded.size() + filesDeleted.size();
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>(size, 1.0f);
        filesAdded.forEach((fileName, fileSize) -> fileInfo.put((String)fileName, new HoodieMetadataFileInfo((Long)fileSize, false)));
        filesDeleted.forEach(fileName -> fileInfo.put((String)fileName, DELETE_FILE_METADATA));
        HoodieKey key = new HoodieKey(partitionIdentifier, MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), MetadataPartitionType.FILES.getRecordType(), fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createBloomFilterMetadataRecord(String partitionName, String baseFileName, String timestamp, String bloomFilterType, ByteBuffer bloomFilter, boolean isDeleted) {
        return HoodieMetadataPayload.createBloomFilterMetadataRecord(partitionName, baseFileName, timestamp, bloomFilterType, bloomFilter, isDeleted, MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
    }

    public static HoodieRecord<HoodieMetadataPayload> createBloomFilterMetadataRecord(String partitionName, String baseFileName, String timestamp, String bloomFilterType, ByteBuffer bloomFilter, boolean isDeleted, String metadataPartitionName) {
        ValidationUtils.checkArgument(!baseFileName.contains("/") && FSUtils.isBaseFile(new StoragePath(baseFileName)), "Invalid base file '" + baseFileName + "' for MetaIndexBloomFilter!");
        String bloomFilterIndexKey = HoodieMetadataPayload.getBloomFilterRecordKey(partitionName, baseFileName);
        HoodieKey key = new HoodieKey(bloomFilterIndexKey, metadataPartitionName);
        HoodieMetadataBloomFilter metadataBloomFilter = new HoodieMetadataBloomFilter(bloomFilterType, timestamp, bloomFilter, isDeleted);
        HoodieMetadataPayload metadataPayload = new HoodieMetadataPayload(key.getRecordKey(), metadataBloomFilter);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, metadataPayload);
    }

    @Override
    public HoodieMetadataPayload preCombine(HoodieMetadataPayload previousRecord) {
        if (this.isDeletedRecord) {
            return this;
        }
        if (previousRecord.isDeletedRecord) {
            return this;
        }
        ValidationUtils.checkArgument(previousRecord.type == this.type, "Cannot combine " + previousRecord.type + " with " + this.type);
        ValidationUtils.checkArgument(previousRecord.key.equals(this.key), "Cannot combine " + previousRecord.key + " with " + this.key + " as the keys differ");
        return MetadataPartitionType.get(this.type).combineMetadataPayloads(previousRecord, this);
    }

    private static String getBloomFilterRecordKey(String partitionName, String fileName) {
        return new PartitionIndexID(HoodieTableMetadataUtil.getBloomFilterIndexPartitionIdentifier(partitionName)).asBase64EncodedString().concat(new FileIndexID(fileName).asBase64EncodedString());
    }

    public static Option<HoodieRecord<HoodieMetadataPayload>> combineSecondaryIndexRecord(HoodieRecord<HoodieMetadataPayload> oldRecord, HoodieRecord<HoodieMetadataPayload> newRecord) {
        if (newRecord.getData().isDeleted() || newRecord.getData().secondaryIndexMetadata.getIsDeleted()) {
            return Option.empty();
        }
        return Option.of(newRecord);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema, Properties properties) throws IOException {
        HoodieMetadataPayload anotherPayload = new HoodieMetadataPayload(Option.of((GenericRecord)oldRecord));
        HoodieMetadataPayload combinedPayload = this.preCombine(anotherPayload);
        return combinedPayload.getInsertValue(schema, properties);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema) throws IOException {
        return this.combineAndGetUpdateValue(oldRecord, schema, new Properties());
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schemaIgnored, Properties propertiesIgnored) throws IOException {
        if (this.key == null || this.isDeletedRecord) {
            return Option.empty();
        }
        HoodieMetadataRecord record = new HoodieMetadataRecord(this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata, this.recordIndexMetadata, this.secondaryIndexMetadata);
        return Option.of(record);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        return this.getInsertValue(schema, new Properties());
    }

    public List<String> getFilenames() {
        return this.filterFileInfoEntries(false).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public List<String> getDeletions() {
        return this.filterFileInfoEntries(true).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public Option<HoodieMetadataBloomFilter> getBloomFilterMetadata() {
        if (this.bloomFilterMetadata == null) {
            return Option.empty();
        }
        return Option.of(this.bloomFilterMetadata);
    }

    public Option<HoodieMetadataColumnStats> getColumnStatMetadata() {
        if (this.columnStatMetadata == null) {
            return Option.empty();
        }
        return Option.of(this.columnStatMetadata);
    }

    public List<StoragePathInfo> getFileList(HoodieStorage storage, StoragePath partitionPath) {
        long blockSize = storage.getDefaultBlockSize(partitionPath);
        return this.filterFileInfoEntries(false).map(e -> new StoragePathInfo(new StoragePath(partitionPath, (String)e.getKey()), ((HoodieMetadataFileInfo)e.getValue()).getSize(), false, 0, blockSize, 0L)).collect(Collectors.toList());
    }

    private Stream<Map.Entry<String, HoodieMetadataFileInfo>> filterFileInfoEntries(boolean isDeleted) {
        if (this.filesystemMetadata == null) {
            return Stream.empty();
        }
        return this.filesystemMetadata.entrySet().stream().filter(e -> ((HoodieMetadataFileInfo)e.getValue()).getIsDeleted() == isDeleted);
    }

    public static String getBloomFilterIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID) {
        return partitionIndexID.asBase64EncodedString().concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID, ColumnIndexID columnIndexID) {
        return columnIndexID.asBase64EncodedString().concat(partitionIndexID.asBase64EncodedString()).concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(String partitionName, HoodieColumnRangeMetadata<Comparable> columnRangeMetadata) {
        PartitionIndexID partitionIndexID = new PartitionIndexID(HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier(partitionName));
        FileIndexID fileIndexID = new FileIndexID(new StoragePath(columnRangeMetadata.getFilePath()).getName());
        ColumnIndexID columnIndexID = new ColumnIndexID(columnRangeMetadata.getColumnName());
        return HoodieMetadataPayload.getColumnStatsIndexKey(partitionIndexID, fileIndexID, columnIndexID);
    }

    public static Stream<HoodieRecord> createColumnStatsRecords(String partitionName, Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList, boolean isDeleted) {
        return columnRangeMetadataList.stream().map(columnRangeMetadata -> HoodieMetadataPayload.createColumnStatsRecord(partitionName, columnRangeMetadata, isDeleted, MetadataPartitionType.COLUMN_STATS.getPartitionPath(), MetadataPartitionType.COLUMN_STATS.getRecordType()));
    }

    public static Stream<HoodieRecord> createColumnStatsRecords(String partitionName, Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList, boolean isDeleted, String metadataPartitionName, int recordType) {
        return columnRangeMetadataList.stream().map(columnRangeMetadata -> HoodieMetadataPayload.createColumnStatsRecord(partitionName, columnRangeMetadata, isDeleted, metadataPartitionName, recordType));
    }

    private static HoodieAvroRecord<HoodieMetadataPayload> createColumnStatsRecord(String partitionName, HoodieColumnRangeMetadata<Comparable> columnRangeMetadata, boolean isDeleted, String metadataPartitionName, int recordType) {
        HoodieKey key = new HoodieKey(HoodieMetadataPayload.getColumnStatsIndexKey(partitionName, columnRangeMetadata), metadataPartitionName);
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), HoodieMetadataColumnStats.newBuilder().setFileName(new StoragePath(columnRangeMetadata.getFilePath()).getName()).setColumnName(columnRangeMetadata.getColumnName()).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMinValue())).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMaxValue())).setNullCount(columnRangeMetadata.getNullCount()).setValueCount(columnRangeMetadata.getValueCount()).setTotalSize(columnRangeMetadata.getTotalSize()).setTotalUncompressedSize(columnRangeMetadata.getTotalUncompressedSize()).setIsDeleted(isDeleted).build(), recordType);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static Stream<HoodieRecord> createPartitionStatsRecords(String partitionPath, Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList, boolean isDeleted, boolean isTightBound, Option<String> indexPartitionOpt) {
        return columnRangeMetadataList.stream().map(columnRangeMetadata -> {
            HoodieKey key = indexPartitionOpt.isPresent() ? new HoodieKey(HoodieTableMetadataUtil.getPartitionStatsIndexKey("__partition_stat__", partitionPath, columnRangeMetadata.getColumnName()), (String)indexPartitionOpt.get()) : new HoodieKey(HoodieTableMetadataUtil.getPartitionStatsIndexKey(partitionPath, columnRangeMetadata.getColumnName()), MetadataPartitionType.PARTITION_STATS.getPartitionPath());
            HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), HoodieMetadataColumnStats.newBuilder().setFileName(columnRangeMetadata.getFilePath()).setColumnName(columnRangeMetadata.getColumnName()).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMinValue())).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMaxValue())).setNullCount(columnRangeMetadata.getNullCount()).setValueCount(columnRangeMetadata.getValueCount()).setTotalSize(columnRangeMetadata.getTotalSize()).setTotalUncompressedSize(columnRangeMetadata.getTotalUncompressedSize()).setIsDeleted(isDeleted).setIsTightBound(isTightBound).build(), MetadataPartitionType.PARTITION_STATS.getRecordType());
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        });
    }

    public static HoodieRecord<HoodieMetadataPayload> createRecordIndexUpdate(String recordKey, String partition, String fileId, String instantTime, int fileIdEncoding) {
        HoodieKey key = new HoodieKey(recordKey, MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        long instantTimeMillis = -1L;
        try {
            instantTimeMillis = TimelineUtils.parseDateFromInstantTime(instantTime).getTime();
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to create metadata payload for record index. Instant time parsing for " + instantTime + " failed ", e);
        }
        if (fileIdEncoding == 0) {
            int fileIndex;
            UUID uuid;
            try {
                if (fileId.length() == 36) {
                    uuid = UUID.fromString(fileId);
                    fileIndex = -1;
                } else {
                    int index = fileId.lastIndexOf("-");
                    uuid = UUID.fromString(fileId.substring(0, index));
                    fileIndex = Integer.parseInt(fileId.substring(index + 1));
                }
            }
            catch (Exception e) {
                throw new HoodieMetadataException(String.format("Invalid UUID or index: fileID=%s, partition=%s, instantTIme=%s", fileId, partition, instantTime), e);
            }
            HoodieMetadataPayload payload = new HoodieMetadataPayload(recordKey, new HoodieRecordIndexInfo(partition, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), fileIndex, "", instantTimeMillis, 0, null));
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        }
        HoodieMetadataPayload payload = new HoodieMetadataPayload(recordKey, new HoodieRecordIndexInfo(partition, -1L, -1L, -1, fileId, instantTimeMillis, 1, null));
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createSecondaryIndexRecord(String recordKey, String secondaryKey, String partitionPath, Boolean isDeleted) {
        HoodieKey key = new HoodieKey(SecondaryIndexKeyUtils.constructSecondaryIndexKey(secondaryKey, recordKey), partitionPath);
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), new HoodieSecondaryIndexInfo(isDeleted));
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public boolean isSecondaryIndexDeleted() {
        return this.secondaryIndexMetadata.getIsDeleted();
    }

    public static HoodieRecord createRecordIndexDelete(String recordKey) {
        HoodieKey key = new HoodieKey(recordKey, MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        return new HoodieAvroRecord<EmptyHoodieRecordPayload>(key, new EmptyHoodieRecordPayload());
    }

    public HoodieRecordGlobalLocation getRecordGlobalLocation() {
        return HoodieTableMetadataUtil.getLocationFromRecordIndexInfo(this.recordIndexMetadata);
    }

    public boolean isDeleted() {
        return this.isDeletedRecord;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HoodieMetadataPayload)) {
            return false;
        }
        HoodieMetadataPayload otherMetadataPayload = (HoodieMetadataPayload)other;
        return this.type == otherMetadataPayload.type && Objects.equals(this.key, otherMetadataPayload.key) && Objects.equals(this.filesystemMetadata, otherMetadataPayload.filesystemMetadata) && Objects.equals(this.bloomFilterMetadata, otherMetadataPayload.bloomFilterMetadata) && Objects.equals(this.columnStatMetadata, otherMetadataPayload.columnStatMetadata) && Objects.equals(this.recordIndexMetadata, otherMetadataPayload.recordIndexMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieMetadataPayload {");
        sb.append("key=").append(this.key).append(", ");
        sb.append("type=").append(this.type).append(", ");
        if (this.type == MetadataPartitionType.FILES.getRecordType() || this.type == MetadataPartitionType.ALL_PARTITIONS.getRecordType()) {
            sb.append("Files: {");
            sb.append("creations=").append(Arrays.toString(this.getFilenames().toArray())).append(", ");
            sb.append("deletions=").append(Arrays.toString(this.getDeletions().toArray())).append(", ");
            sb.append("}");
        } else if (this.type == MetadataPartitionType.BLOOM_FILTERS.getRecordType()) {
            ValidationUtils.checkState(this.getBloomFilterMetadata().isPresent());
            sb.append("BloomFilter: {");
            sb.append("bloom size: ").append(this.getBloomFilterMetadata().get().getBloomFilter().array().length).append(", ");
            sb.append("timestamp: ").append(this.getBloomFilterMetadata().get().getTimestamp()).append(", ");
            sb.append("deleted: ").append(this.getBloomFilterMetadata().get().getIsDeleted());
            sb.append("}");
        } else if (this.type == MetadataPartitionType.COLUMN_STATS.getRecordType()) {
            ValidationUtils.checkState(this.getColumnStatMetadata().isPresent());
            sb.append("ColStats: {");
            sb.append(this.getColumnStatMetadata().get());
            sb.append("}");
        } else if (this.type == MetadataPartitionType.RECORD_INDEX.getRecordType()) {
            sb.append("RecordIndex: {");
            sb.append("location=").append(this.getRecordGlobalLocation());
            sb.append("}");
        }
        sb.append('}');
        return sb.toString();
    }
}

