/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.hadoop.OrcReaderIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class HoodieAvroOrcReader
extends HoodieAvroFileReader {
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils orcUtils;

    public HoodieAvroOrcReader(HoodieStorage storage, StoragePath path) {
        this.storage = storage;
        this.path = path;
        this.orcUtils = HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.ORC);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.orcUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.orcUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    @Override
    public Set<Pair<String, Long>> filterRowKeys(Set candidateRowKeys) {
        return this.orcUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        Configuration hadoopConf = this.storage.getConf().unwrapAs(Configuration.class);
        try (Reader reader = OrcFile.createReader((Path)new Path(this.path.toUri()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf));){
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(readerSchema);
            RecordReader recordReader = reader.rows(new Reader.Options(hadoopConf).schema(orcSchema));
            OrcReaderIterator<IndexedRecord> orcReaderIterator = new OrcReaderIterator<IndexedRecord>(recordReader, readerSchema, orcSchema);
            return orcReaderIterator;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader.", io);
        }
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() {
        final Iterator<String> iterator = this.orcUtils.readRowKeys(this.storage, this.path).iterator();
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)iterator.next();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public Schema getSchema() {
        return this.orcUtils.readAvroSchema(this.storage, this.path);
    }

    @Override
    public void close() {
    }

    @Override
    public long getTotalRecords() {
        return this.orcUtils.getRowCount(this.storage, this.path);
    }
}

