/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChange;

public class TableChangesHelper {
    public static List<Types.Field> applyAddChange2Fields(List<Types.Field> fields, ArrayList<Types.Field> adds, ArrayList<TableChange.ColumnPositionChange> pchanges) {
        if (adds == null && pchanges == null) {
            return fields;
        }
        LinkedList<Types.Field> result = new LinkedList<Types.Field>(fields);
        if (adds != null && !adds.isEmpty()) {
            result.addAll(adds);
        }
        if (pchanges != null && !pchanges.isEmpty()) {
            for (TableChange.ColumnPositionChange pchange : pchanges) {
                Types.Field srcField = result.stream().filter(f -> f.fieldId() == pchange.getSrcId()).findFirst().get();
                Types.Field dsrField = result.stream().filter(f -> f.fieldId() == pchange.getDsrId()).findFirst().orElse(null);
                result.remove(srcField);
                switch (pchange.type()) {
                    case AFTER: {
                        result.add(result.indexOf(dsrField) + 1, srcField);
                        break;
                    }
                    case BEFORE: {
                        result.add(result.indexOf(dsrField), srcField);
                        break;
                    }
                    case FIRST: {
                        result.addFirst(srcField);
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static String getParentName(String fullColName) {
        int offset = fullColName.lastIndexOf(".");
        return offset > 0 ? fullColName.substring(0, offset) : "";
    }

    public static String getLeafName(String fullColName) {
        int offset = fullColName.lastIndexOf(".");
        return offset > 0 ? fullColName.substring(offset + 1) : fullColName;
    }
}

