/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.LeafExpression;
import org.apache.hudi.expression.StructLike;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class Literal<T>
extends LeafExpression {
    private final T value;
    private final Type type;

    public static <V> Literal from(V value) {
        if (value instanceof Integer || value instanceof Short) {
            return new Literal<V>(value, Types.IntType.get());
        }
        if (value instanceof Byte) {
            return new Literal<Integer>(((Byte)value).intValue(), Types.IntType.get());
        }
        if (value instanceof Long) {
            return new Literal<V>(value, Types.LongType.get());
        }
        if (value instanceof Boolean) {
            return new Literal<V>(value, Types.BooleanType.get());
        }
        if (value instanceof Double) {
            return new Literal<V>(value, Types.DoubleType.get());
        }
        if (value instanceof Float) {
            return new Literal<V>(value, Types.FloatType.get());
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            return new Literal<V>(value, Types.DecimalType.get(decimal.precision(), decimal.scale()));
        }
        if (value instanceof CharSequence) {
            return new Literal<V>(value, Types.StringType.get());
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new Literal<ByteBuffer>(ByteBuffer.wrap(bytes), Types.FixedType.getFixed(bytes.length));
        }
        if (value instanceof ByteBuffer) {
            return new Literal<V>(value, Types.BinaryType.get());
        }
        if (value instanceof UUID) {
            return new Literal<V>(value, Types.UUIDType.get());
        }
        throw new IllegalArgumentException("Cannot convert value from class " + value.getClass().getName() + " to Literal");
    }

    public Literal(T value, Type type) {
        this.value = value;
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Type getDataType() {
        return this.type;
    }

    @Override
    public Object eval(StructLike data) {
        return this.value;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> exprVisitor) {
        return exprVisitor.visitLiteral(this);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof ByteBuffer) {
            return DatatypeConverter.printHexBinary((byte[])((ByteBuffer)this.value).array());
        }
        return this.value.toString();
    }
}

