/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.LeafExpression;
import org.apache.hudi.expression.StructLike;
import org.apache.hudi.internal.schema.Type;

public class BoundReference
extends LeafExpression {
    private final int ordinal;
    private final Type type;

    public BoundReference(int ordinal, Type type) {
        this.ordinal = ordinal;
        this.type = type;
    }

    @Override
    public Type getDataType() {
        return this.type;
    }

    @Override
    public Object eval(StructLike data) {
        return data.get(this.ordinal, this.type.typeId().getClassTag());
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> exprVisitor) {
        return exprVisitor.visitBoundReference(this);
    }

    @Override
    public String toString() {
        return "boundReference[ordinal: " + this.ordinal + ", type: " + this.type.typeId().getName() + "]";
    }
}

