/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for M3", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using M3.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsM3Config
extends HoodieConfig {
    public static final String M3_PREFIX = "hoodie.metrics.m3";
    public static final ConfigProperty<String> M3_SERVER_HOST_NAME = ConfigProperty.key("hoodie.metrics.m3.host").defaultValue("localhost").sinceVersion("0.15.0").withDocumentation("M3 host to connect to.");
    public static final ConfigProperty<Integer> M3_SERVER_PORT_NUM = ConfigProperty.key("hoodie.metrics.m3.port").defaultValue(9052).sinceVersion("0.15.0").withDocumentation("M3 port to connect to.");
    public static final ConfigProperty<String> M3_TAGS = ConfigProperty.key("hoodie.metrics.m3.tags").defaultValue("").sinceVersion("0.15.0").withDocumentation("Optional M3 tags applied to all metrics.");
    public static final ConfigProperty<String> M3_ENV = ConfigProperty.key("hoodie.metrics.m3.env").defaultValue("production").sinceVersion("0.15.0").withDocumentation("M3 tag to label the environment (defaults to 'production'), applied to all metrics.");
    public static final ConfigProperty<String> M3_SERVICE = ConfigProperty.key("hoodie.metrics.m3.service").defaultValue("hoodie").sinceVersion("0.15.0").withDocumentation("M3 tag to label the service name (defaults to 'hoodie'), applied to all metrics.");

    private HoodieMetricsM3Config() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsM3Config hoodieMetricsM3Config = new HoodieMetricsM3Config();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsM3Config.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsM3Config.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder toM3Host(String host) {
            this.hoodieMetricsM3Config.setValue(M3_SERVER_HOST_NAME, host);
            return this;
        }

        public Builder onM3Port(int port) {
            this.hoodieMetricsM3Config.setValue(M3_SERVER_PORT_NUM, String.valueOf(port));
            return this;
        }

        public Builder useM3Tags(String tags) {
            this.hoodieMetricsM3Config.setValue(M3_TAGS, tags);
            return this;
        }

        public Builder useM3Env(String env) {
            this.hoodieMetricsM3Config.setValue(M3_ENV, env);
            return this;
        }

        public Builder useM3Service(String service) {
            this.hoodieMetricsM3Config.setValue(M3_SERVICE, service);
            return this;
        }

        public HoodieMetricsM3Config build() {
            this.hoodieMetricsM3Config.setDefaults(HoodieMetricsM3Config.class.getName());
            return this.hoodieMetricsM3Config;
        }
    }
}

