/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;

public class InstantFileNameParserV2
implements InstantFileNameParser {
    private static final Pattern NAME_FORMAT = Pattern.compile("^(\\d+(_\\d+)?)(\\.\\w+)(\\.\\D+)?$");

    @Override
    public String extractTimestamp(String fileName) throws IllegalArgumentException {
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            String timestamp = matcher.group(1);
            return timestamp.contains("_") ? timestamp.split("_")[0] : timestamp;
        }
        throw new IllegalArgumentException("Failed to retrieve timestamp from name: " + String.format("The provided file name %s does not conform to the required format", fileName));
    }

    @Override
    public String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return fileName.substring(matcher.group(1).length());
        }
        return "";
    }
}

