/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.clean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StoragePath;

public class CleanPlanV2MigrationHandler
extends AbstractMigratorBase<HoodieCleanerPlan> {
    public static final Integer VERSION = 2;

    public CleanPlanV2MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCleanerPlan upgradeFrom(HoodieCleanerPlan plan) {
        Map<String, List<HoodieCleanFileInfo>> filePathsPerPartition = plan.getFilesToBeDeletedPerPartition().entrySet().stream().map(e -> Pair.of(e.getKey(), ((List)e.getValue()).stream().map(v -> new HoodieCleanFileInfo(new StoragePath(FSUtils.constructAbsolutePath(this.metaClient.getBasePath(), (String)e.getKey()), (String)v).toString(), false)).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return new HoodieCleanerPlan(plan.getEarliestInstantToRetain(), plan.getLastCompletedCommitTimestamp(), plan.getPolicy(), new HashMap<String, List<String>>(), VERSION, filePathsPerPartition, new ArrayList<String>(), Collections.emptyMap());
    }

    @Override
    public HoodieCleanerPlan downgradeFrom(HoodieCleanerPlan input) {
        throw new IllegalArgumentException("This is the current highest version. Plan cannot be any higher version");
    }
}

