/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.clean;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StoragePath;

public class CleanMetadataV1MigrationHandler
extends AbstractMigratorBase<HoodieCleanMetadata> {
    public static final Integer VERSION = 1;

    public CleanMetadataV1MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCleanMetadata upgradeFrom(HoodieCleanMetadata input) {
        throw new IllegalArgumentException("This is the lowest version. Input cannot be any lower version");
    }

    @Override
    public HoodieCleanMetadata downgradeFrom(HoodieCleanMetadata input) {
        ValidationUtils.checkArgument(input.getVersion() == 2, "Input version is " + input.getVersion() + ". Must be 2");
        StoragePath basePath = this.metaClient.getBasePath();
        Map<String, HoodieCleanPartitionMetadata> partitionMetadataMap = input.getPartitionMetadata().entrySet().stream().map(entry -> {
            String partitionPath = (String)entry.getKey();
            HoodieCleanPartitionMetadata partitionMetadata = (HoodieCleanPartitionMetadata)entry.getValue();
            HoodieCleanPartitionMetadata cleanPartitionMetadata = HoodieCleanPartitionMetadata.newBuilder().setDeletePathPatterns(partitionMetadata.getDeletePathPatterns().stream().map(path -> CleanMetadataV1MigrationHandler.convertToV1Path(basePath, partitionMetadata.getPartitionPath(), path)).collect(Collectors.toList())).setSuccessDeleteFiles(partitionMetadata.getSuccessDeleteFiles().stream().map(path -> CleanMetadataV1MigrationHandler.convertToV1Path(basePath, partitionMetadata.getPartitionPath(), path)).collect(Collectors.toList())).setPartitionPath(partitionPath).setFailedDeleteFiles(partitionMetadata.getFailedDeleteFiles().stream().map(path -> CleanMetadataV1MigrationHandler.convertToV1Path(basePath, partitionMetadata.getPartitionPath(), path)).collect(Collectors.toList())).setPolicy(partitionMetadata.getPolicy()).setPartitionPath(partitionPath).build();
            return Pair.of(partitionPath, cleanPartitionMetadata);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return HoodieCleanMetadata.newBuilder().setEarliestCommitToRetain(input.getEarliestCommitToRetain()).setLastCompletedCommitTimestamp(input.getLastCompletedCommitTimestamp()).setStartCleanTime(input.getStartCleanTime()).setTimeTakenInMillis(input.getTimeTakenInMillis()).setTotalFilesDeleted(input.getTotalFilesDeleted()).setPartitionMetadata(partitionMetadataMap).setVersion(this.getManagedVersion()).build();
    }

    private static String convertToV1Path(StoragePath basePath, String partitionPath, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return fileName;
        }
        return new StoragePath(FSUtils.constructAbsolutePath(basePath, partitionPath), fileName).toString();
    }
}

