/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.org.apache.avro.Schema;

public class UnmergedFileGroupRecordBuffer<T>
extends FileGroupRecordBuffer<T> {
    private Long putIndex = 0L;
    private Long getIndex = 0L;

    public UnmergedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState(this.baseFileIterator != null, "Base file iterator has not been set yet");
        if (this.baseFileIterator.hasNext()) {
            this.nextRecord = this.readerContext.seal(this.baseFileIterator.next());
            return true;
        }
        if (!this.records.isEmpty()) {
            Long l = this.getIndex;
            Long l2 = this.getIndex = Long.valueOf(this.getIndex + 1L);
            BufferedRecord nextRecordInfo = (BufferedRecord)this.records.remove(l);
            if (nextRecordInfo == null) {
                throw new HoodieException("Row index should be continuous!");
            }
            if (nextRecordInfo.isDelete()) {
                throw new IllegalStateException("No deletes should exist in unmerged reading mode");
            }
            this.nextRecord = nextRecordInfo.getRecord();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<BufferedRecord<T>> getLogRecordIterator() {
        return this.records.values().iterator();
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.UNMERGED;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates()) {
            throw new HoodieException("Partial update is not supported for unmerged record read");
        }
        Schema schema = AvroSchemaCache.intern(recordsIteratorSchemaPair.getRight());
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                BufferedRecord bufferedRecord = BufferedRecord.forRecordWithContext(nextRecord, schema, this.readerContext, this.orderingFieldName, false);
                Long l = this.putIndex;
                Long l2 = this.putIndex = Long.valueOf(this.putIndex + 1L);
                this.processNextDataRecord(bufferedRecord, l);
            }
        }
    }

    @Override
    public void processNextDataRecord(BufferedRecord<T> record, Serializable index) {
        this.records.put(index, record.toBinary(this.readerContext));
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) {
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable index) {
        this.records.put(index, BufferedRecord.forDeleteRecord(deleteRecord, UnmergedFileGroupRecordBuffer.getOrderingValue(this.readerContext, deleteRecord)));
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }
}

