/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

public abstract class InstantRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Option<String> startInstant;
    protected final Option<String> endInstant;

    public InstantRange(String startInstant, String endInstant) {
        this.startInstant = Option.ofNullable(startInstant);
        this.endInstant = Option.ofNullable(endInstant);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Option<String> getStartInstant() {
        return this.startInstant;
    }

    public Option<String> getEndInstant() {
        return this.endInstant;
    }

    public abstract boolean isInRange(String var1);

    public String toString() {
        return "InstantRange{startInstant='" + (this.startInstant.isEmpty() ? "-INF" : this.startInstant.get()) + '\'' + ", endInstant='" + (this.endInstant.isEmpty() ? "+INF" : this.endInstant.get()) + '\'' + ", rangeType='" + this.getClass().getSimpleName() + '\'' + '}';
    }

    public static class Builder {
        private String startInstant;
        private String endInstant;
        private RangeType rangeType;
        private boolean nullableBoundary = false;
        private Set<String> explicitInstants;
        private List<InstantRange> instantRanges;

        private Builder() {
        }

        public Builder startInstant(String startInstant) {
            this.startInstant = startInstant;
            return this;
        }

        public Builder endInstant(String endInstant) {
            this.endInstant = endInstant;
            return this;
        }

        public Builder rangeType(RangeType rangeType) {
            this.rangeType = rangeType;
            return this;
        }

        public Builder nullableBoundary(boolean nullable) {
            this.nullableBoundary = nullable;
            return this;
        }

        public Builder explicitInstants(Set<String> instants) {
            this.explicitInstants = instants;
            return this;
        }

        public Builder instantRanges(InstantRange ... instantRanges) {
            this.instantRanges = Arrays.stream(instantRanges).collect(Collectors.toList());
            return this;
        }

        public InstantRange build() {
            ValidationUtils.checkState(this.rangeType != null, "Range type is required");
            switch (this.rangeType) {
                case OPEN_CLOSED: {
                    return this.nullableBoundary ? new OpenClosedRangeNullableBoundary(this.startInstant, this.endInstant) : new OpenClosedRange(this.startInstant, this.endInstant);
                }
                case CLOSED_CLOSED: {
                    return this.nullableBoundary ? new ClosedClosedRangeNullableBoundary(this.startInstant, this.endInstant) : new ClosedClosedRange(this.startInstant, this.endInstant);
                }
                case EXACT_MATCH: {
                    return new ExactMatchRange(this.explicitInstants);
                }
                case COMPOSITION: {
                    return new CompositionRange(this.instantRanges);
                }
            }
            throw new AssertionError();
        }
    }

    private static class CompositionRange
    extends InstantRange {
        List<InstantRange> instantRanges;

        public CompositionRange(List<InstantRange> instantRanges) {
            super(null, null);
            this.instantRanges = Objects.requireNonNull(instantRanges, "Instant ranges should not be null");
        }

        @Override
        public boolean isInRange(String instant) {
            for (InstantRange range : this.instantRanges) {
                if (!range.isInRange(instant)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExactMatchRange
    extends InstantRange {
        Set<String> instants;

        public ExactMatchRange(Set<String> instants) {
            super(Collections.min(instants), Collections.max(instants));
            this.instants = instants;
        }

        @Override
        public boolean isInRange(String instant) {
            return this.instants.contains(instant);
        }
    }

    private static class ClosedClosedRangeNullableBoundary
    extends InstantRange {
        public ClosedClosedRangeNullableBoundary(String startInstant, String endInstant) {
            super(startInstant, endInstant);
            ValidationUtils.checkArgument(!startInstant.isEmpty() || !endInstant.isEmpty(), "At least one of start and end instants should be specified.");
        }

        @Override
        public boolean isInRange(String instant) {
            boolean validAgainstStart = this.startInstant.map(s -> InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN_OR_EQUALS, s)).orElse(true);
            boolean validAgainstEnd = this.endInstant.map(e -> InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN_OR_EQUALS, e)).orElse(true);
            return validAgainstStart && validAgainstEnd;
        }
    }

    private static class ClosedClosedRange
    extends InstantRange {
        public ClosedClosedRange(String startInstant, String endInstant) {
            super(Objects.requireNonNull(startInstant), endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            boolean validAgainstStart = InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN_OR_EQUALS, (String)this.startInstant.get());
            boolean validAgainstEnd = this.endInstant.map(e -> InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN_OR_EQUALS, e)).orElse(true);
            return validAgainstStart && validAgainstEnd;
        }
    }

    private static class OpenClosedRangeNullableBoundary
    extends InstantRange {
        public OpenClosedRangeNullableBoundary(String startInstant, String endInstant) {
            super(startInstant, endInstant);
            ValidationUtils.checkArgument(!startInstant.isEmpty() || !endInstant.isEmpty(), "At least one of start and end instants should be specified.");
        }

        @Override
        public boolean isInRange(String instant) {
            boolean validAgainstStart = this.startInstant.map(s -> InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN, s)).orElse(true);
            boolean validAgainstEnd = this.endInstant.map(e -> InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN_OR_EQUALS, e)).orElse(true);
            return validAgainstStart && validAgainstEnd;
        }
    }

    private static class OpenClosedRange
    extends InstantRange {
        public OpenClosedRange(String startInstant, String endInstant) {
            super(Objects.requireNonNull(startInstant), endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            boolean validAgainstStart = InstantComparison.compareTimestamps(instant, InstantComparison.GREATER_THAN, (String)this.startInstant.get());
            boolean validAgainstEnd = this.endInstant.map(e -> InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN_OR_EQUALS, e)).orElse(true);
            return validAgainstStart && validAgainstEnd;
        }
    }

    public static enum RangeType {
        OPEN_CLOSED,
        CLOSED_CLOSED,
        EXACT_MATCH,
        COMPOSITION;

    }
}

