/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.cdc;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.cdc.HoodieCDCInferenceCase;
import org.apache.hudi.common.util.Option;

public class HoodieCDCFileSplit
implements Serializable,
Comparable<HoodieCDCFileSplit> {
    private final String instant;
    private final HoodieCDCInferenceCase cdcInferCase;
    private final List<String> cdcFiles;
    private final Option<FileSlice> beforeFileSlice;
    private final Option<FileSlice> afterFileSlice;

    public HoodieCDCFileSplit(String instant, HoodieCDCInferenceCase cdcInferCase, String cdcFile) {
        this(instant, cdcInferCase, cdcFile, Option.empty(), Option.empty());
    }

    public HoodieCDCFileSplit(String instant, HoodieCDCInferenceCase cdcInferCase, Collection<String> cdcFiles) {
        this(instant, cdcInferCase, cdcFiles, Option.empty(), Option.empty());
    }

    public HoodieCDCFileSplit(String instant, HoodieCDCInferenceCase cdcInferCase, String cdcFile, Option<FileSlice> beforeFileSlice, Option<FileSlice> afterFileSlice) {
        this(instant, cdcInferCase, Collections.singletonList(cdcFile), beforeFileSlice, afterFileSlice);
    }

    public HoodieCDCFileSplit(String instant, HoodieCDCInferenceCase cdcInferCase, Collection<String> cdcFiles, Option<FileSlice> beforeFileSlice, Option<FileSlice> afterFileSlice) {
        this.instant = instant;
        this.cdcInferCase = cdcInferCase;
        this.cdcFiles = cdcFiles.stream().sorted(Comparator.comparingInt(FSUtils::getFileVersionFromLog)).collect(Collectors.toList());
        this.beforeFileSlice = beforeFileSlice;
        this.afterFileSlice = afterFileSlice;
    }

    public String getInstant() {
        return this.instant;
    }

    public HoodieCDCInferenceCase getCdcInferCase() {
        return this.cdcInferCase;
    }

    public List<String> getCdcFiles() {
        return this.cdcFiles;
    }

    public Option<FileSlice> getBeforeFileSlice() {
        return this.beforeFileSlice;
    }

    public Option<FileSlice> getAfterFileSlice() {
        return this.afterFileSlice;
    }

    @Override
    public int compareTo(HoodieCDCFileSplit o) {
        return this.instant.compareTo(o.instant);
    }
}

