/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Locale;
import org.apache.hudi.exception.HoodieException;

public enum WriteOperationType {
    INSERT("insert"),
    INSERT_PREPPED("insert_prepped"),
    UPSERT("upsert"),
    UPSERT_PREPPED("upsert_prepped"),
    BULK_INSERT("bulk_insert"),
    BULK_INSERT_PREPPED("bulk_insert_prepped"),
    DELETE("delete"),
    DELETE_PREPPED("delete_prepped"),
    BOOTSTRAP("bootstrap"),
    INSERT_OVERWRITE("insert_overwrite"),
    CLUSTER("cluster"),
    DELETE_PARTITION("delete_partition"),
    INSERT_OVERWRITE_TABLE("insert_overwrite_table"),
    COMPACT("compact"),
    INDEX("index"),
    ALTER_SCHEMA("alter_schema"),
    LOG_COMPACT("log_compact"),
    UNKNOWN("unknown");

    private final String value;

    private WriteOperationType(String value) {
        this.value = value;
    }

    public static WriteOperationType fromValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "insert": {
                return INSERT;
            }
            case "insert_prepped": {
                return INSERT_PREPPED;
            }
            case "upsert": {
                return UPSERT;
            }
            case "upsert_prepped": {
                return UPSERT_PREPPED;
            }
            case "bulk_insert": {
                return BULK_INSERT;
            }
            case "bulk_insert_prepped": {
                return BULK_INSERT_PREPPED;
            }
            case "delete": {
                return DELETE;
            }
            case "delete_prepped": {
                return DELETE_PREPPED;
            }
            case "insert_overwrite": {
                return INSERT_OVERWRITE;
            }
            case "delete_partition": {
                return DELETE_PARTITION;
            }
            case "insert_overwrite_table": {
                return INSERT_OVERWRITE_TABLE;
            }
            case "cluster": {
                return CLUSTER;
            }
            case "compact": {
                return COMPACT;
            }
            case "index": {
                return INDEX;
            }
            case "alter_schema": {
                return ALTER_SCHEMA;
            }
            case "log_compact": {
                return LOG_COMPACT;
            }
            case "unknown": {
                return UNKNOWN;
            }
        }
        throw new HoodieException("Invalid value of Type.");
    }

    public String value() {
        return this.value;
    }

    public static boolean isChangingRecords(WriteOperationType operationType) {
        return operationType == UPSERT || operationType == UPSERT_PREPPED || operationType == DELETE || operationType == DELETE_PREPPED;
    }

    public static boolean isOverwrite(WriteOperationType operationType) {
        return operationType == INSERT_OVERWRITE || operationType == INSERT_OVERWRITE_TABLE;
    }

    public boolean isInsertOverwriteOrDeletePartition() {
        return this == INSERT_OVERWRITE || this == INSERT_OVERWRITE_TABLE || this == DELETE_PARTITION;
    }

    public static boolean yieldChanges(WriteOperationType operation) {
        return operation == INSERT || operation == UPSERT || operation == UPSERT_PREPPED || operation == DELETE || operation == DELETE_PREPPED || operation == BULK_INSERT || operation == DELETE_PARTITION || operation == INSERT_OVERWRITE || operation == INSERT_OVERWRITE_TABLE || operation == BOOTSTRAP;
    }

    public static boolean canUpdateSchema(WriteOperationType operation) {
        return operation != CLUSTER && operation != COMPACT && operation != INDEX && operation != LOG_COMPACT;
    }

    public static boolean isInsert(WriteOperationType operation) {
        return operation == INSERT || operation == INSERT_PREPPED || operation == BULK_INSERT || operation == BULK_INSERT_PREPPED || operation == INSERT_OVERWRITE || operation == INSERT_OVERWRITE_TABLE;
    }

    public static boolean isUpsert(WriteOperationType operation) {
        return operation == UPSERT || operation == UPSERT_PREPPED;
    }

    public static boolean isDelete(WriteOperationType operation) {
        return operation == DELETE || operation == DELETE_PREPPED;
    }

    public static boolean isPreppedWriteOperation(WriteOperationType operationType) {
        return operationType == BULK_INSERT_PREPPED || operationType == INSERT_PREPPED | operationType == UPSERT_PREPPED || operationType == DELETE_PREPPED;
    }

    public static boolean isCompactionOrClustering(WriteOperationType operationType) {
        return operationType == COMPACT || operationType == CLUSTER;
    }
}

