/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class DefaultHoodieRecordPayload
extends OverwriteWithLatestAvroPayload {
    public static final String METADATA_EVENT_TIME_KEY = "metadata.event_time.key";
    public static final String DELETE_KEY = "hoodie.payload.delete.field";
    public static final String DELETE_MARKER = "hoodie.payload.delete.marker";
    private Option<Object> eventTime = Option.empty();
    private final AtomicBoolean isDeleteComputed = new AtomicBoolean(false);
    private boolean isDefaultRecordPayloadDeleted = false;

    public DefaultHoodieRecordPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public DefaultHoodieRecordPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        if (!this.needUpdatingPersistedRecord(currentValue, incomingRecord, properties)) {
            return Option.of(currentValue);
        }
        this.eventTime = DefaultHoodieRecordPayload.updateEventTime(incomingRecord, properties);
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, properties);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : Option.of(incomingRecord);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        this.eventTime = DefaultHoodieRecordPayload.updateEventTime(incomingRecord, properties);
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, properties);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : Option.of(incomingRecord);
    }

    @Override
    public boolean isDeleted(Schema schema, Properties props) {
        if (this.recordBytes.length == 0) {
            return true;
        }
        try {
            if (!this.isDeleteComputed.getAndSet(true)) {
                GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
                this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, props);
            }
            return this.isDefaultRecordPayloadDeleted;
        }
        catch (IOException e) {
            throw new HoodieIOException("Deserializing bytes to avro failed ", e);
        }
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord, Properties properties) {
        String deleteKey = properties.getProperty(DELETE_KEY);
        if (StringUtils.isNullOrEmpty(deleteKey)) {
            return this.isDeleteRecord(genericRecord);
        }
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(properties.getProperty(DELETE_MARKER)), () -> "hoodie.payload.delete.marker should be configured with hoodie.payload.delete.field");
        if (genericRecord.getSchema().getField(deleteKey) == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get(deleteKey);
        return deleteMarker != null && properties.getProperty(DELETE_MARKER).equals(deleteMarker.toString());
    }

    private static Option<Object> updateEventTime(GenericRecord record, Properties properties) {
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        String eventTimeField = properties.getProperty("hoodie.payload.event.time.field");
        if (eventTimeField == null) {
            return Option.empty();
        }
        return Option.ofNullable(HoodieAvroUtils.getNestedFieldVal(record, eventTimeField, true, consistentLogicalTimestampEnabled));
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.eventTime.isPresent()) {
            metadata.put(METADATA_EVENT_TIME_KEY, String.valueOf(this.eventTime.get()));
        }
        return metadata.isEmpty() ? Option.empty() : Option.of(metadata);
    }

    protected boolean needUpdatingPersistedRecord(IndexedRecord currentValue, IndexedRecord incomingRecord, Properties properties) {
        String orderField = ConfigUtils.getOrderingField(properties);
        if (orderField == null) {
            return true;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        Object persistedOrderingVal = HoodieAvroUtils.getNestedFieldVal((GenericRecord)currentValue, orderField, true, consistentLogicalTimestampEnabled);
        Comparable incomingOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)incomingRecord, orderField, true, consistentLogicalTimestampEnabled);
        return persistedOrderingVal == null || ((Comparable)persistedOrderingVal).compareTo(incomingOrderingVal) <= 0;
    }
}

