/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class BaseFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient StoragePathInfo pathInfo;
    private final String fullPath;
    protected final String fileName;
    private long fileLen;

    public BaseFile(BaseFile dataFile) {
        this(dataFile.pathInfo, dataFile.fullPath, dataFile.getFileName(), dataFile.getFileLen());
    }

    public BaseFile(StoragePathInfo pathInfo) {
        this(pathInfo, pathInfo.getPath().toString(), pathInfo.getPath().getName(), pathInfo.getLength());
    }

    public BaseFile(String filePath) {
        this(null, filePath, BaseFile.getFileName(filePath), -1L);
    }

    private BaseFile(StoragePathInfo pathInfo, String fullPath, String fileName, long fileLen) {
        this.pathInfo = pathInfo;
        this.fullPath = fullPath;
        this.fileLen = fileLen;
        this.fileName = fileName;
    }

    public String getPath() {
        return this.fullPath;
    }

    public StoragePath getStoragePath() {
        if (this.pathInfo != null) {
            return this.pathInfo.getPath();
        }
        return new StoragePath(this.fullPath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public StoragePathInfo getPathInfo() {
        return this.pathInfo;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileLen() {
        return this.fileLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseFile dataFile = (BaseFile)o;
        return Objects.equals(this.fullPath, dataFile.fullPath);
    }

    public int hashCode() {
        return Objects.hash(this.fullPath);
    }

    public String toString() {
        return "BaseFile{fullPath=" + this.fullPath + ", fileLen=" + this.fileLen + '}';
    }

    private static String getFileName(String fullPath) {
        return new StoragePath(fullPath).getName();
    }
}

