/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.LogicalType;
import org.apache.hudi.org.apache.avro.Schema;

public abstract class TimeLogicalTypeProcessor
extends JsonFieldProcessor {
    protected static final LocalDateTime LOCAL_UNIX_EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0);
    private final AvroLogicalTypeEnum logicalTypeEnum;
    private static final Map<AvroLogicalTypeEnum, DateTimeParseContext> DATE_TIME_PARSE_CONTEXT_MAP = TimeLogicalTypeProcessor.getParseContext();
    protected static final Pattern ALL_DIGITS_WITH_OPTIONAL_SIGN = Pattern.compile("^[-+]?\\d{1,19}$");

    public TimeLogicalTypeProcessor(AvroLogicalTypeEnum logicalTypeEnum) {
        this.logicalTypeEnum = logicalTypeEnum;
    }

    public Pair<Boolean, Object> convertCommon(Parser parser, Object value, Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == null) {
            return Pair.of(false, null);
        }
        logicalType.validate(schema);
        if (value instanceof Number) {
            return parser.handleNumberValue((Number)value);
        }
        if (value instanceof String) {
            String valStr = (String)value;
            if (ALL_DIGITS_WITH_OPTIONAL_SIGN.matcher(valStr).matches()) {
                return parser.handleStringNumber(valStr);
            }
            return parser.handleStringValue(valStr);
        }
        return Pair.of(false, null);
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        DateTimeParseContext ctx = DATE_TIME_PARSE_CONTEXT_MAP.get((Object)this.logicalTypeEnum);
        return ctx == null ? null : ctx.dateTimeFormatter;
    }

    protected Pattern getDateTimePattern() {
        DateTimeParseContext ctx = DATE_TIME_PARSE_CONTEXT_MAP.get((Object)this.logicalTypeEnum);
        return ctx == null ? null : ctx.dateTimePattern;
    }

    private static Map<AvroLogicalTypeEnum, DateTimeParseContext> getParseContext() {
        DateTimeFormatter localDateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
        DateTimeParseContext dateTimestampParseContext = new DateTimeParseContext(new DateTimeFormatterBuilder().parseCaseInsensitive().append(localDateTimeFormatter).optionalStart().appendOffsetId().optionalEnd().parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE), null);
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(DateTimeFormatter.ISO_LOCAL_TIME, Pattern.compile("^[+-]?\\d{2}:\\d{2}(?::\\d{2}(?:\\.\\d{1,9})?)?"));
        DateTimeParseContext localTimestampParseContext = new DateTimeParseContext(localDateTimeFormatter, Pattern.compile("^[+-]?\\d{4,10}-\\d{2}-\\d{2}[T ]\\d{2}:\\d{2}(?::\\d{2}(?:\\.\\d{1,9})?)?"));
        DateTimeParseContext localDateParseContext = new DateTimeParseContext(DateTimeFormatter.ISO_LOCAL_DATE, Pattern.compile("^[+-]?\\d{4,10}-\\d{2}-\\d{2}?"));
        EnumMap<AvroLogicalTypeEnum, DateTimeParseContext> ctx = new EnumMap<AvroLogicalTypeEnum, DateTimeParseContext>(AvroLogicalTypeEnum.class);
        ctx.put(AvroLogicalTypeEnum.TIME_MICROS, dateTimeParseContext);
        ctx.put(AvroLogicalTypeEnum.TIME_MILLIS, dateTimeParseContext);
        ctx.put(AvroLogicalTypeEnum.DATE, localDateParseContext);
        ctx.put(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MICROS, localTimestampParseContext);
        ctx.put(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MILLIS, localTimestampParseContext);
        ctx.put(AvroLogicalTypeEnum.TIMESTAMP_MICROS, dateTimestampParseContext);
        ctx.put(AvroLogicalTypeEnum.TIMESTAMP_MILLIS, dateTimestampParseContext);
        return Collections.unmodifiableMap(ctx);
    }

    protected boolean isWellFormedDateTime(String value) {
        Pattern pattern = this.getDateTimePattern();
        return pattern == null || pattern.matcher(value).matches();
    }

    protected Pair<Boolean, Instant> convertToInstantTime(String input) {
        Instant time = null;
        try {
            ZonedDateTime dateTime = ZonedDateTime.parse(input, this.getDateTimeFormatter());
            time = dateTime.toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return Pair.of(time != null, time);
    }

    protected Pair<Boolean, LocalTime> convertToLocalTime(String input) {
        LocalTime time = null;
        try {
            time = LocalTime.parse(input);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return Pair.of(time != null, time);
    }

    protected Pair<Boolean, LocalDateTime> convertToLocalDateTime(String input) {
        LocalDateTime time = null;
        try {
            time = LocalDateTime.parse(input, this.getDateTimeFormatter());
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return Pair.of(time != null, time);
    }

    protected Pair<Boolean, Object> convertDateTime(String value, Function<LocalTime, Object> localTimeFunction, Function<Instant, Object> instantTimeFunction) {
        if (!this.isWellFormedDateTime(value)) {
            return Pair.of(false, null);
        }
        if (localTimeFunction != null) {
            Pair<Boolean, LocalTime> result = this.convertToLocalTime(value);
            if (!result.getLeft().booleanValue()) {
                return Pair.of(false, null);
            }
            return Pair.of(true, localTimeFunction.apply(result.getRight()));
        }
        if (instantTimeFunction != null) {
            Pair<Boolean, Instant> result = this.convertToInstantTime(value);
            if (!result.getLeft().booleanValue()) {
                return Pair.of(false, null);
            }
            return Pair.of(true, instantTimeFunction.apply(result.getRight()));
        }
        return Pair.of(false, null);
    }

    private static class DateTimeParseContext {
        public final Pattern dateTimePattern;
        public final DateTimeFormatter dateTimeFormatter;

        public DateTimeParseContext(DateTimeFormatter dateTimeFormatter, Pattern dateTimePattern) {
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateTimePattern = dateTimePattern;
        }
    }
}

