/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.sql.Date;
import org.apache.hudi.common.util.collection.Pair;

public abstract class Parser {
    abstract Pair<Boolean, Object> handleNumberValue(Number var1);

    abstract Pair<Boolean, Object> handleStringNumber(String var1);

    abstract Pair<Boolean, Object> handleStringValue(String var1);

    public static class LongParser
    extends Parser {
        @Override
        public Pair<Boolean, Object> handleNumberValue(Number value) {
            return Pair.of(true, value.longValue());
        }

        @Override
        public Pair<Boolean, Object> handleStringNumber(String value) {
            return Pair.of(true, Long.parseLong(value));
        }

        @Override
        public Pair<Boolean, Object> handleStringValue(String value) {
            return Pair.of(true, Long.valueOf(value));
        }
    }

    public static class DateParser
    extends Parser {
        private static final long MILLI_SECONDS_PER_DAY = 86400000L;

        @Override
        public Pair<Boolean, Object> handleNumberValue(Number value) {
            return Pair.of(true, new Date((long)value.intValue() * 86400000L));
        }

        @Override
        public Pair<Boolean, Object> handleStringNumber(String value) {
            return Pair.of(true, new Date((long)Integer.parseInt(value) * 86400000L));
        }

        @Override
        public Pair<Boolean, Object> handleStringValue(String value) {
            return Pair.of(true, Date.valueOf(value));
        }
    }

    public static class IntParser
    extends Parser {
        @Override
        public Pair<Boolean, Object> handleNumberValue(Number value) {
            return Pair.of(true, value.intValue());
        }

        @Override
        public Pair<Boolean, Object> handleStringNumber(String value) {
            return Pair.of(true, Integer.parseInt(value));
        }

        @Override
        public Pair<Boolean, Object> handleStringValue(String value) {
            return Pair.of(true, Integer.valueOf(value));
        }
    }
}

