/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class OrcReaderIterator<T>
implements ClosableIterator<T> {
    private final RecordReader recordReader;
    private final Schema avroSchema;
    private final List<String> fieldNames;
    private final List<TypeDescription> orcFieldTypes;
    private final Schema[] avroFieldSchemas;
    private final VectorizedRowBatch batch;
    private int rowInBatch;
    private T next;

    public OrcReaderIterator(RecordReader recordReader, Schema schema, TypeDescription orcSchema) {
        this.recordReader = recordReader;
        this.avroSchema = schema;
        this.fieldNames = orcSchema.getFieldNames();
        this.orcFieldTypes = orcSchema.getChildren();
        this.avroFieldSchemas = (Schema[])this.fieldNames.stream().map(fieldName -> this.avroSchema.getField(fieldName).schema()).toArray(Schema[]::new);
        this.batch = orcSchema.createRowBatch();
        this.rowInBatch = 0;
    }

    private boolean ensureBatch() throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            this.rowInBatch = 0;
            return this.recordReader.nextBatch(this.batch);
        }
        return true;
    }

    public boolean hasNext() {
        try {
            this.ensureBatch();
            if (this.next == null) {
                this.next = this.readRecordFromBatch();
            }
            return this.next != null;
        }
        catch (IOException io) {
            throw new HoodieIOException("unable to read next record from ORC file ", io);
        }
    }

    public T next() {
        try {
            if (this.next == null && !this.hasNext()) {
                throw new HoodieIOException("No more records left to read from ORC file");
            }
            T retVal = this.next;
            this.next = this.readRecordFromBatch();
            return retVal;
        }
        catch (IOException io) {
            throw new HoodieIOException("unable to read next record from ORC file ", io);
        }
    }

    private GenericData.Record readRecordFromBatch() throws IOException {
        if (!this.ensureBatch()) {
            return null;
        }
        GenericData.Record record = new GenericData.Record(this.avroSchema);
        int numFields = this.orcFieldTypes.size();
        for (int i = 0; i < numFields; ++i) {
            Object data = AvroOrcUtils.readFromVector(this.orcFieldTypes.get(i), this.batch.cols[i], this.avroFieldSchemas[i], this.rowInBatch);
            record.put(this.fieldNames.get(i), data);
        }
        ++this.rowInBatch;
        return record;
    }

    public void close() {
        FileIOUtils.closeQuietly((Closeable)this.recordReader);
    }
}

