/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.HFileUtils;
import org.apache.hudi.common.util.OrcUtils;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.hadoop.HoodieHadoopIOFactory;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieHadoopIOFactory {
    @Test
    public void testGetFileFormatUtils() throws IOException {
        try (HoodieHadoopStorage storage = new HoodieHadoopStorage(HadoopFSUtils.getFs((String)"file:///", (StorageConfiguration)HoodieTestUtils.getDefaultStorageConf()));){
            HoodieHadoopIOFactory ioFactory = new HoodieHadoopIOFactory((HoodieStorage)storage);
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(new StoragePath("file:///a/b.parquet")) instanceof ParquetUtils));
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(new StoragePath("file:///a/b.orc")) instanceof OrcUtils));
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(new StoragePath("file:///a/b.hfile")) instanceof HFileUtils));
            Assertions.assertThrows(UnsupportedOperationException.class, () -> TestHoodieHadoopIOFactory.lambda$testGetFileFormatUtils$0((HoodieIOFactory)ioFactory));
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(HoodieFileFormat.PARQUET) instanceof ParquetUtils));
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(HoodieFileFormat.ORC) instanceof OrcUtils));
            Assertions.assertTrue((boolean)(ioFactory.getFileFormatUtils(HoodieFileFormat.HFILE) instanceof HFileUtils));
            Assertions.assertThrows(UnsupportedOperationException.class, () -> TestHoodieHadoopIOFactory.lambda$testGetFileFormatUtils$1((HoodieIOFactory)ioFactory));
        }
    }

    private static /* synthetic */ void lambda$testGetFileFormatUtils$1(HoodieIOFactory ioFactory) throws Throwable {
        ioFactory.getFileFormatUtils(HoodieFileFormat.HOODIE_LOG);
    }

    private static /* synthetic */ void lambda$testGetFileFormatUtils$0(HoodieIOFactory ioFactory) throws Throwable {
        ioFactory.getFileFormatUtils(new StoragePath("file:///a/b.log"));
    }
}

