/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.parquet.hadoop.ParquetReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestParquetReaderIterator {
    @Test
    public void testParquetIteratorIdempotency() throws IOException {
        ParquetReader reader = (ParquetReader)Mockito.mock(ParquetReader.class);
        Mockito.when((Object)reader.read()).thenReturn((Object)1).thenReturn(null);
        ParquetReaderIterator iterator = new ParquetReaderIterator(reader);
        for (int idempotencyCheckCounter = 0; idempotencyCheckCounter < 3; ++idempotencyCheckCounter) {
            Assertions.assertTrue((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testParquetIterator() throws IOException {
        ParquetReader reader = (ParquetReader)Mockito.mock(ParquetReader.class);
        Mockito.when((Object)reader.read()).thenReturn((Object)1).thenReturn(null);
        ParquetReaderIterator iterator = new ParquetReaderIterator(reader);
        Assertions.assertEquals((int)1, (Integer)((Integer)iterator.next()));
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(HoodieException.class, () -> ((ParquetReaderIterator)iterator).next(), (String)"should throw an exception since there is only 1 record");
        ((ParquetReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.times((int)1))).close();
    }
}

