/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.orc.TypeDescription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestAvroOrcUtils
extends HoodieCommonTestHarness {
    public static final TypeDescription ORC_SCHEMA = AvroOrcUtils.createOrcSchema((Schema)new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"));
    public static final TypeDescription ORC_TRIP_SCHEMA = AvroOrcUtils.createOrcSchema((Schema)new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}"));

    public static List<Arguments> testCreateOrcSchemaArgs() {
        TypeDescription orcSchema = TypeDescription.fromString((String)"struct<timestamp:bigint,_row_key:string,partition_path:string,trip_type:string,rider:string,driver:string,begin_lat:double,begin_lon:double,end_lat:double,end_lon:double,distance_in_meters:int,seconds_since_epoch:bigint,weight:float,nation:binary,current_date:date,current_ts:bigint,height:decimal(10,6),city_to_state:map<string,string>,fare:struct<amount:double,currency:string>,tip_history:array<struct<amount:double,currency:string>>,_hoodie_is_deleted:boolean>");
        String structField = "{\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}";
        Schema avroSchemaWithMoreTypes = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\" : \"age\", \"type\":{\"type\": \"fixed\", \"size\": 16, \"name\": \"fixedField\" }},{\"name\" : \"height\", \"type\": [\"int\", \"null\"] },{\"name\" : \"id\", \"type\": [\"int\", \"string\"] },{\"name\" : \"fare\", \"type\": [" + structField + ", \"null\"] }]}");
        TypeDescription orcSchemaWithMoreTypes = TypeDescription.fromString((String)"struct<age:binary,height:int,id:uniontype<int,string>,fare:struct<amount:double,currency:string>>");
        return Arrays.asList(Arguments.of((Object[])new Object[]{HoodieTestDataGenerator.AVRO_SCHEMA, orcSchema}), Arguments.of((Object[])new Object[]{avroSchemaWithMoreTypes, orcSchemaWithMoreTypes}));
    }

    @ParameterizedTest
    @MethodSource(value={"testCreateOrcSchemaArgs"})
    public void testCreateOrcSchema(Schema avroSchema, TypeDescription orcSchema) {
        TypeDescription convertedSchema = AvroOrcUtils.createOrcSchema((Schema)avroSchema);
        Assertions.assertEquals((Object)orcSchema, (Object)convertedSchema);
    }
}

