/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.TestEventTimeMerging;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.reader.DataGenerationPlan;
import org.apache.hudi.common.testutils.reader.HoodieAvroRecordTestMerger;
import org.apache.hudi.common.testutils.reader.HoodieFileGroupReaderTestHarness;
import org.apache.hudi.common.testutils.reader.HoodieFileSliceTestUtils;
import org.apache.hudi.common.testutils.reader.HoodieRecordTestPayload;
import org.apache.hudi.common.testutils.reader.HoodieTestReaderContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieFileGroupReaderInflightCommit
extends HoodieFileGroupReaderTestHarness {
    @BeforeAll
    public static void setUp() throws IOException {
        HoodieAvroRecordTestMerger merger = new HoodieAvroRecordTestMerger();
        readerContext = new HoodieTestReaderContext(Option.of((Object)merger), Option.of((Object)HoodieRecordTestPayload.class.getName()));
        keyRanges = Arrays.asList(new HoodieFileSliceTestUtils.KeyRange(1, 5), new HoodieFileSliceTestUtils.KeyRange(1, 3));
        timestamps = Arrays.asList(2L, 3L);
        operationTypes = Arrays.asList(DataGenerationPlan.OperationType.INSERT, DataGenerationPlan.OperationType.UPDATE);
        instantTimes = Arrays.asList("001", "002");
        shouldWritePositions = Arrays.asList(false, false);
    }

    @BeforeEach
    public void initialize() throws Exception {
        this.setTableName(TestEventTimeMerging.class.getName());
        this.initPath(this.tableName);
        this.initMetaClient();
        this.initTestDataGenerator(new String[]{"any-partition-path"});
        testTable = HoodieTestTable.of(this.metaClient);
        this.setUpMockCommits();
    }

    @Test
    public void testInflightDataRead() throws IOException, InterruptedException {
        testTable.moveCompleteCommitToInflight((String)instantTimes.get(1));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(2, false, true);
        List<String> leftKeysExpected = Arrays.asList("1", "2", "3", "4", "5");
        List<Long> leftTimestampsExpected = Arrays.asList(3L, 3L, 3L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }
}

