/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.AvroBinaryTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.HoodieCommonKryoRegistrar;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class TestHoodieRecordDelegate {
    private HoodieRecordDelegate hoodieRecordDelegate;

    @BeforeEach
    public void setUp() throws Exception {
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List indexedRecords = testUtil.generateHoodieTestRecords(0, 1);
        List hoodieRecords = indexedRecords.stream().map(r -> new HoodieAvroRecord(new HoodieKey("001", "0000/00/00"), (HoodieRecordPayload)new AvroBinaryTestPayload(Option.of((Object)((GenericRecord)r))))).collect(Collectors.toList());
        HoodieRecord record = (HoodieRecord)hoodieRecords.get(0);
        record.setCurrentLocation(new HoodieRecordLocation("001", "file01"));
        record.setNewLocation(new HoodieRecordLocation("001", "file-01"));
        this.hoodieRecordDelegate = HoodieRecordDelegate.fromHoodieRecord((HoodieRecord)record);
    }

    @Test
    public void testKryoSerializeDeserialize() {
        Kryo kryo = this.getKryoInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        kryo.reset();
        baos.reset();
        Output output = new Output((OutputStream)baos);
        this.hoodieRecordDelegate.write(kryo, output);
        output.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Input input = new Input((InputStream)bais);
        this.hoodieRecordDelegate.read(kryo, input);
        input.close();
        Assertions.assertEquals((Object)new HoodieKey("001", "0000/00/00"), (Object)this.hoodieRecordDelegate.getHoodieKey());
        Assertions.assertEquals((Object)new HoodieRecordLocation("001", "file01"), (Object)this.hoodieRecordDelegate.getCurrentLocation().get());
        Assertions.assertEquals((Object)new HoodieRecordLocation("001", "file-01"), (Object)this.hoodieRecordDelegate.getNewLocation().get());
    }

    public Kryo getKryoInstance() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        new HoodieCommonKryoRegistrar().registerClasses(kryo);
        return kryo;
    }
}

