/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.AvroBinaryTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieRecord {
    private HoodieRecord hoodieRecord;

    @BeforeEach
    public void setUp() throws Exception {
        SchemaTestUtil testUtil = new SchemaTestUtil();
        List indexedRecords = testUtil.generateHoodieTestRecords(0, 1);
        List hoodieRecords = indexedRecords.stream().map(r -> new HoodieAvroRecord(new HoodieKey(UUID.randomUUID().toString(), "0000/00/00"), (HoodieRecordPayload)new AvroBinaryTestPayload(Option.of((Object)((GenericRecord)r))))).collect(Collectors.toList());
        this.hoodieRecord = (HoodieRecord)hoodieRecords.get(0);
    }

    @Test
    public void testModificationAfterSeal() {
        this.hoodieRecord.seal();
        HoodieRecordLocation location = new HoodieRecordLocation("100", "0");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.hoodieRecord.setCurrentLocation(location), (String)"should fail since modification after sealed is not allowed");
    }

    @Test
    public void testNormalModification() {
        this.hoodieRecord.unseal();
        HoodieRecordLocation location = new HoodieRecordLocation("100", "0");
        this.hoodieRecord.setCurrentLocation(location);
        this.hoodieRecord.seal();
        this.hoodieRecord.unseal();
        this.hoodieRecord.setNewLocation(location);
        this.hoodieRecord.seal();
    }
}

