/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.inline.TestInLineFileSystemHFileInLiningBase;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopSeekableDataInputStream;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.junit.jupiter.api.Assertions;

public class TestInLineFileSystemWithHFileReader
extends TestInLineFileSystemHFileInLiningBase {
    @Override
    protected void validateHFileReading(InLineFileSystem inlineFileSystem, Configuration conf, Configuration inlineConf, Path inlinePath, int maxRows) throws IOException {
        long fileSize = inlineFileSystem.getFileStatus(inlinePath).getLen();
        try (HadoopSeekableDataInputStream stream = new HadoopSeekableDataInputStream(inlineFileSystem.open(inlinePath));
             HFileReaderImpl reader = new HFileReaderImpl((SeekableDataInputStream)stream, fileSize);){
            int[] invalidRowIds;
            reader.seekTo();
            this.readAllRecords((HFileReader)reader, maxRows);
            reader.seekTo();
            List rowIdsToSearch = this.getRandomValidRowIds(10).stream().sorted().collect(Collectors.toList());
            Iterator iterator = rowIdsToSearch.iterator();
            while (iterator.hasNext()) {
                int rowId = (Integer)iterator.next();
                Key lookupKey = this.getKey(rowId);
                Assertions.assertEquals((int)0, (int)reader.seekTo(lookupKey), (String)"location lookup failed");
                Option keyValue = reader.getKeyValue();
                Assertions.assertTrue((boolean)keyValue.isPresent());
                Assertions.assertEquals((Object)lookupKey, (Object)((KeyValue)keyValue.get()).getKey(), (String)"seeked key does not match");
                reader.seekTo(lookupKey);
                String val1 = HFileUtils.getValue((KeyValue)((KeyValue)reader.getKeyValue().get()));
                reader.seekTo(lookupKey);
                String val2 = HFileUtils.getValue((KeyValue)((KeyValue)reader.getKeyValue().get()));
                Assertions.assertEquals((Object)val1, (Object)val2);
            }
            reader.seekTo();
            for (int rowId : invalidRowIds = new int[]{-4, maxRows, maxRows + 1, maxRows + 120, maxRows + 160, maxRows + 1000}) {
                Assertions.assertNotEquals((int)0, (int)reader.seekTo(this.getKey(rowId)), (String)"location lookup should have failed");
            }
        }
    }

    private Key getKey(int rowId) {
        return new UTF8StringKey(String.format("%010d", rowId));
    }

    private void readAllRecords(HFileReader reader, int maxRows) throws IOException {
        for (int i = 0; i < maxRows; ++i) {
            Option keyValue = reader.getKeyValue();
            Assertions.assertTrue((boolean)keyValue.isPresent());
            String key = ((KeyValue)keyValue.get()).getKey().getContentInString();
            String value = HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get()));
            String expectedKeyStr = String.format("%010d", i);
            String expectedValStr = "value" + expectedKeyStr;
            Assertions.assertEquals((Object)expectedKeyStr, (Object)key, (String)("keys do not match " + expectedKeyStr + " " + key));
            Assertions.assertEquals((Object)expectedValStr, (Object)value, (String)("values do not match " + expectedValStr + " " + value));
            Assertions.assertEquals((Object)(i != maxRows - 1 ? 1 : 0), (Object)reader.next());
        }
    }
}

