/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewStorageProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ViewStorageProperties.class);
    private static final String FILE_NAME = "view_storage_conf.properties";

    public static void createProperties(String basePath, FileSystemViewStorageConfig config, Configuration flinkConf) throws IOException {
        Path propertyPath = ViewStorageProperties.getPropertiesFilePath(basePath);
        FileSystem fs = FSUtils.getFs(basePath, HadoopConfigurations.getHadoopConf(flinkConf));
        fs.delete(propertyPath, false);
        try (FSDataOutputStream outputStream = fs.create(propertyPath);){
            config.getProps().store((OutputStream)outputStream, "Filesystem view storage properties saved on " + new Date(System.currentTimeMillis()));
        }
    }

    public static FileSystemViewStorageConfig loadFromProperties(String basePath, Configuration conf) {
        Path propertyPath = ViewStorageProperties.getPropertiesFilePath(basePath);
        LOG.info("Loading filesystem view storage properties from " + propertyPath);
        FileSystem fs = FSUtils.getFs(basePath, HadoopConfigurations.getHadoopConf(conf));
        Properties props = new Properties();
        try {
            try (FSDataInputStream inputStream = fs.open(propertyPath);){
                props.load((InputStream)inputStream);
            }
            return FileSystemViewStorageConfig.newBuilder().fromProperties(props).build();
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load filesystem view storage properties from " + propertyPath, e);
        }
    }

    private static Path getPropertiesFilePath(String basePath) {
        String auxPath = basePath + "/" + ".hoodie/.aux";
        return new Path(auxPath, FILE_NAME);
    }
}

