/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.org.apache.avro.generic.GenericDatumReader;
import org.apache.hudi.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.io.BinaryDecoder;
import org.apache.hudi.org.apache.avro.io.BinaryEncoder;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;
import org.apache.hudi.org.apache.avro.io.EncoderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class BaseMergeHelper<T extends HoodieRecordPayload, I, K, O> {
    public abstract void runMerge(HoodieTable<T, I, K, O> var1, HoodieMergeHandle<T, I, K, O> var2) throws IOException;

    protected GenericRecord transformRecordBasedOnNewSchema(GenericDatumReader<GenericRecord> gReader, GenericDatumWriter<GenericRecord> gWriter, ThreadLocal<BinaryEncoder> encoderCache, ThreadLocal<BinaryDecoder> decoderCache, GenericRecord gRec) {
        ByteArrayOutputStream inStream = null;
        try {
            GenericRecord transformedRec;
            inStream = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(inStream, encoderCache.get());
            encoderCache.set(encoder);
            gWriter.write(gRec, encoder);
            encoder.flush();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inStream.toByteArray(), decoderCache.get());
            decoderCache.set(decoder);
            GenericRecord genericRecord = transformedRec = (GenericRecord)gReader.read(null, decoder);
            return genericRecord;
        }
        catch (IOException e) {
            throw new HoodieException(e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                throw new HoodieException(ioe.getMessage(), ioe);
            }
        }
    }

    protected static class UpdateHandler
    extends BoundedInMemoryQueueConsumer<GenericRecord, Void> {
        private final HoodieMergeHandle upsertHandle;

        protected UpdateHandler(HoodieMergeHandle upsertHandle) {
            this.upsertHandle = upsertHandle;
        }

        @Override
        protected void consumeOneRecord(GenericRecord record) {
            this.upsertHandle.write(record);
        }

        @Override
        protected void finish() {
        }

        @Override
        protected Void getResult() {
            return null;
        }
    }
}

