/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.webapp;

import java.io.IOException;
import org.apache.hudi.org.apache.jetty.servlet.ErrorPageErrorHandler;
import org.apache.hudi.org.apache.jetty.util.log.Log;
import org.apache.hudi.org.apache.jetty.util.log.Logger;
import org.apache.hudi.org.apache.jetty.util.resource.Resource;
import org.apache.hudi.org.apache.jetty.webapp.AbstractConfiguration;
import org.apache.hudi.org.apache.jetty.webapp.StandardDescriptorProcessor;
import org.apache.hudi.org.apache.jetty.webapp.WebAppContext;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebXmlConfiguration.class);

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = context.newResource(defaultsDescriptor);
            }
            context.getMetaData().setDefaults(dftResource);
        }
        if ((webxml = this.findWebXml(context)) != null) {
            context.getMetaData().setWebXml(webxml);
            context.getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebXml().getMajorVersion());
            context.getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebXml().getMinorVersion());
        }
        for (String overrideDescriptor : context.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource(overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            context.getMetaData().addOverride(orideResource);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        context.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context) throws IOException {
        Resource web;
        String descriptor = context.getDescriptor();
        if (descriptor != null && (web = context.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web2 = webInf.addPath("web.xml");
            if (web2.exists()) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in " + context.getWar() + ". Serving files and default/dynamic servlets only", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.setWelcomeFiles(null);
        if (context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)context.getErrorHandler()).setErrorPages(null);
        }
    }
}

