/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.wal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hudi.org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BoundedGroupingStrategy
implements RegionGroupingProvider.RegionGroupingStrategy {
    static final String NUM_REGION_GROUPS = "hbase.wal.regiongrouping.numgroups";
    static final int DEFAULT_NUM_REGION_GROUPS = 2;
    private ConcurrentHashMap<String, String> groupNameCache = new ConcurrentHashMap();
    private AtomicInteger counter = new AtomicInteger(0);
    private String[] groupNames;

    @Override
    public String group(byte[] identifier, byte[] namespace) {
        String idStr = Bytes.toString(identifier);
        return ConcurrentMapUtils.computeIfAbsent(this.groupNameCache, idStr, () -> this.groupNames[this.getAndIncrAtomicInteger(this.counter, this.groupNames.length)]);
    }

    private int getAndIncrAtomicInteger(AtomicInteger atomicInt, int reset) {
        int next;
        int current;
        do {
            if ((next = (current = atomicInt.get()) + 1) != reset) continue;
            next = 0;
        } while (!atomicInt.compareAndSet(current, next));
        return current;
    }

    @Override
    public void init(Configuration config, String providerId) {
        int regionGroupNumber = config.getInt(NUM_REGION_GROUPS, 2);
        this.groupNames = new String[regionGroupNumber];
        for (int i = 0; i < regionGroupNumber; ++i) {
            this.groupNames[i] = providerId + "." + "regiongroup-" + i;
        }
    }
}

