/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.util.compaction.ClusterCompactionQueues;
import org.apache.hudi.org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import org.apache.hudi.org.apache.hadoop.hbase.util.compaction.MajorCompactionTTLRequest;
import org.apache.hudi.org.apache.hadoop.hbase.util.compaction.MajorCompactor;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class MajorCompactorTTL
extends MajorCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactorTTL.class);
    private TableDescriptor htd;

    @InterfaceAudience.Private
    public MajorCompactorTTL(Configuration conf, TableDescriptor htd, int concurrency, long sleepForMs) throws IOException {
        this.connection = ConnectionFactory.createConnection(conf);
        this.htd = htd;
        this.tableName = htd.getTableName();
        this.storesToCompact = Sets.newHashSet();
        this.sleepForMs = sleepForMs;
        this.executor = Executors.newFixedThreadPool(concurrency);
        this.clusterCompactionQueues = new ClusterCompactionQueues(concurrency);
    }

    protected MajorCompactorTTL() {
    }

    @Override
    protected Optional<MajorCompactionRequest> getMajorCompactionRequest(RegionInfo hri) throws IOException {
        return MajorCompactionTTLRequest.newRequest(this.connection.getConfiguration(), hri, this.htd);
    }

    @Override
    protected Set<String> getStoresRequiringCompaction(MajorCompactionRequest request) throws IOException {
        return ((MajorCompactionTTLRequest)request).getStoresRequiringCompaction(this.htd).keySet();
    }

    public int compactRegionsTTLOnTable(Configuration conf, String table, int concurrency, long sleep, int numServers, int numRegions, boolean dryRun, boolean skipWait) throws Exception {
        Connection conn = ConnectionFactory.createConnection(conf);
        TableName tableName = TableName.valueOf(table);
        TableDescriptor htd = conn.getAdmin().getDescriptor(tableName);
        if (!this.doesAnyColFamilyHaveTTL(htd)) {
            LOG.info("No TTL present for CF of table: " + tableName + ", skipping compaction");
            return 0;
        }
        LOG.info("Major compacting table " + tableName + " based on TTL");
        MajorCompactorTTL compactor = new MajorCompactorTTL(conf, htd, concurrency, sleep);
        compactor.setNumServers(numServers);
        compactor.setNumRegions(numRegions);
        compactor.setSkipWait(skipWait);
        compactor.initializeWorkQueues();
        if (!dryRun) {
            compactor.compactAllRegions();
        }
        compactor.shutdown();
        return ERRORS.size();
    }

    private boolean doesAnyColFamilyHaveTTL(TableDescriptor htd) {
        for (ColumnFamilyDescriptor descriptor : htd.getColumnFamilies()) {
            if (descriptor.getTimeToLive() == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private Options getOptions() {
        Options options = this.getCommonOptions();
        options.addOption(Option.builder("table").required().desc("table name").hasArg().build());
        return options;
    }

    @Override
    public int run(String[] args2) throws Exception {
        CommandLine commandLine;
        Options options = this.getOptions();
        DefaultParser cmdLineParser = new DefaultParser();
        try {
            commandLine = cmdLineParser.parse(options, args2);
        }
        catch (ParseException parseException) {
            System.out.println("ERROR: Unable to parse command-line arguments " + Arrays.toString(args2) + " due to: " + parseException);
            MajorCompactorTTL.printUsage(options);
            return -1;
        }
        if (commandLine == null) {
            System.out.println("ERROR: Failed parse, empty commandLine; " + Arrays.toString(args2));
            MajorCompactorTTL.printUsage(options);
            return -1;
        }
        String table = commandLine.getOptionValue("table");
        int numServers = Integer.parseInt(commandLine.getOptionValue("numservers", "-1"));
        int numRegions = Integer.parseInt(commandLine.getOptionValue("numregions", "-1"));
        int concurrency = Integer.parseInt(commandLine.getOptionValue("servers", "1"));
        long sleep = Long.parseLong(commandLine.getOptionValue("sleep", Long.toString(30000L)));
        boolean dryRun = commandLine.hasOption("dryRun");
        boolean skipWait = commandLine.hasOption("skipWait");
        return this.compactRegionsTTLOnTable(HBaseConfiguration.create(), table, concurrency, sleep, numServers, numRegions, dryRun, skipWait);
    }

    public static void main(String[] args2) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new MajorCompactorTTL(), (String[])args2);
    }
}

