/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import org.apache.hudi.com.codahale.metrics.Histogram;
import org.apache.hudi.com.codahale.metrics.Reservoir;
import org.apache.hudi.com.codahale.metrics.Snapshot;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class YammerHistogramUtils {
    private static DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#0.00");

    private YammerHistogramUtils() {
    }

    public static Histogram newHistogram(Reservoir sample) {
        try {
            Constructor ctor = Histogram.class.getDeclaredConstructor(Reservoir.class);
            ctor.setAccessible(true);
            return (Histogram)ctor.newInstance(sample);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getShortHistogramReport(Histogram hist) {
        Snapshot sn = hist.getSnapshot();
        return "mean=" + DOUBLE_FORMAT.format(sn.getMean()) + ", min=" + DOUBLE_FORMAT.format(sn.getMin()) + ", max=" + DOUBLE_FORMAT.format(sn.getMax()) + ", stdDev=" + DOUBLE_FORMAT.format(sn.getStdDev()) + ", 95th=" + DOUBLE_FORMAT.format(sn.get95thPercentile()) + ", 99th=" + DOUBLE_FORMAT.format(sn.get99thPercentile());
    }

    public static String getHistogramReport(Histogram hist) {
        Snapshot sn = hist.getSnapshot();
        return "mean=" + DOUBLE_FORMAT.format(sn.getMean()) + ", min=" + DOUBLE_FORMAT.format(sn.getMin()) + ", max=" + DOUBLE_FORMAT.format(sn.getMax()) + ", stdDev=" + DOUBLE_FORMAT.format(sn.getStdDev()) + ", 50th=" + DOUBLE_FORMAT.format(sn.getMedian()) + ", 75th=" + DOUBLE_FORMAT.format(sn.get75thPercentile()) + ", 95th=" + DOUBLE_FORMAT.format(sn.get95thPercentile()) + ", 99th=" + DOUBLE_FORMAT.format(sn.get99thPercentile()) + ", 99.9th=" + DOUBLE_FORMAT.format(sn.get999thPercentile()) + ", 99.99th=" + DOUBLE_FORMAT.format(sn.getValue(0.9999)) + ", 99.999th=" + DOUBLE_FORMAT.format(sn.getValue(0.99999));
    }

    public static String getPrettyHistogramReport(Histogram h) {
        Snapshot sn = h.getSnapshot();
        return "Mean      = " + DOUBLE_FORMAT.format(sn.getMean()) + "\nMin       = " + DOUBLE_FORMAT.format(sn.getMin()) + "\nMax       = " + DOUBLE_FORMAT.format(sn.getMax()) + "\nStdDev    = " + DOUBLE_FORMAT.format(sn.getStdDev()) + "\n50th      = " + DOUBLE_FORMAT.format(sn.getMedian()) + "\n75th      = " + DOUBLE_FORMAT.format(sn.get75thPercentile()) + "\n95th      = " + DOUBLE_FORMAT.format(sn.get95thPercentile()) + "\n99th      = " + DOUBLE_FORMAT.format(sn.get99thPercentile()) + "\n99.9th    = " + DOUBLE_FORMAT.format(sn.get999thPercentile()) + "\n99.99th   = " + DOUBLE_FORMAT.format(sn.getValue(0.9999)) + "\n99.999th  = " + DOUBLE_FORMAT.format(sn.getValue(0.99999));
    }
}

