/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hudi.org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.hudi.org.apache.hadoop.hbase.util.WeakObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class KeyLocker<K> {
    private static final int NB_CONCURRENT_LOCKS = 1000;
    private final WeakObjectPool<K, ReentrantLock> lockPool = new WeakObjectPool(new ObjectPool.ObjectFactory<K, ReentrantLock>(){

        @Override
        public ReentrantLock createObject(K key) {
            return new ReentrantLock();
        }
    }, 1000);

    public ReentrantLock acquireLock(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.lockPool.purge();
        ReentrantLock lock = (ReentrantLock)this.lockPool.get(key);
        lock.lock();
        return lock;
    }

    public Map<K, Lock> acquireLocks(Set<? extends K> keys2) {
        Object[] keyArray = keys2.toArray();
        Arrays.sort(keyArray);
        this.lockPool.purge();
        LinkedHashMap<Object, ReentrantLock> locks = new LinkedHashMap<Object, ReentrantLock>(keyArray.length);
        Object[] objectArray = keyArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object o;
            Object key = o = objectArray[i];
            ReentrantLock lock = (ReentrantLock)this.lockPool.get(key);
            locks.put(key, lock);
        }
        for (Lock lock : locks.values()) {
            lock.lock();
        }
        return locks;
    }
}

