/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractPositionedByteRange
extends AbstractByteRange
implements PositionedByteRange {
    protected int position = 0;
    protected int limit = 0;

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        this.limit = capacity;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes) {
        this.position = 0;
        super.set(bytes);
        this.limit = bytes.length;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes, int offset, int length) {
        this.position = 0;
        super.set(bytes, offset, length);
        this.limit = length;
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset) {
        this.position = 0;
        super.setOffset(offset);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length) {
        this.position = Math.min(this.position, length);
        super.setLength(length);
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public PositionedByteRange setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getRemaining() {
        return this.length - this.position;
    }

    @Override
    public byte peek() {
        return this.bytes[this.offset + this.position];
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public PositionedByteRange get(byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(dst, 0, dst.length);
    }

    @Override
    public PositionedByteRange get(byte[] dst, int offset, int length) {
        if (0 == length) {
            return this;
        }
        super.get(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst) {
        super.get(index, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst, int offset, int length) {
        super.get(index, dst, offset, length);
        return this;
    }

    @Override
    public short getShort() {
        short s = this.getShort(this.position);
        this.position += 2;
        return s;
    }

    @Override
    public int getInt() {
        int i = this.getInt(this.position);
        this.position += 4;
        return i;
    }

    @Override
    public long getLong() {
        long l = this.getLong(this.position);
        this.position += 8;
        return l;
    }

    @Override
    public long getVLong() {
        long p = this.getVLong(this.position);
        this.position += AbstractPositionedByteRange.getVLongSize(p);
        return p;
    }

    @Override
    public PositionedByteRange setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

