/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class OrderedInt64
extends OrderedBytesBase<Long> {
    public static final OrderedInt64 ASCENDING = new OrderedInt64(Order.ASCENDING);
    public static final OrderedInt64 DESCENDING = new OrderedInt64(Order.DESCENDING);

    protected OrderedInt64(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Long val) {
        return 9;
    }

    @Override
    public Class<Long> encodedClass() {
        return Long.class;
    }

    @Override
    public Long decode(PositionedByteRange src) {
        return OrderedBytes.decodeInt64(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Long val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeInt64(dst, val, this.order);
    }

    public long decodeLong(PositionedByteRange src) {
        return OrderedBytes.decodeInt64(src);
    }

    public int encodeLong(PositionedByteRange dst, long val) {
        return OrderedBytes.encodeInt64(dst, val, this.order);
    }
}

