/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshPeerCallable
implements RSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshPeerCallable.class);
    private HRegionServer rs;
    private String peerId;
    private MasterProcedureProtos.PeerModificationType type;
    private Exception initError;

    @Override
    public Void call() throws Exception {
        if (this.initError != null) {
            throw this.initError;
        }
        LOG.info("Received a peer change event, peerId=" + this.peerId + ", type=" + this.type);
        PeerProcedureHandler handler = this.rs.getReplicationSourceService().getPeerProcedureHandler();
        switch (this.type) {
            case ADD_PEER: {
                handler.addPeer(this.peerId);
                break;
            }
            case REMOVE_PEER: {
                handler.removePeer(this.peerId);
                break;
            }
            case ENABLE_PEER: {
                handler.enablePeer(this.peerId);
                break;
            }
            case DISABLE_PEER: {
                handler.disablePeer(this.peerId);
                break;
            }
            case UPDATE_PEER_CONFIG: {
                handler.updatePeerConfig(this.peerId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown peer modification type: " + this.type);
            }
        }
        return null;
    }

    @Override
    public void init(byte[] parameter, HRegionServer rs) {
        this.rs = rs;
        try {
            MasterProcedureProtos.RefreshPeerParameter param = MasterProcedureProtos.RefreshPeerParameter.parseFrom(parameter);
            this.peerId = param.getPeerId();
            this.type = param.getType();
        }
        catch (InvalidProtocolBufferException e) {
            this.initError = e;
        }
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_REFRESH_PEER;
    }
}

